/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.ajax.parser.ContactSearchtermSqlConverter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistration;
import com.openexchange.groupware.contact.ContactMergerator;
import com.openexchange.groupware.contact.helpers.CollationContactComparator;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.contact.helpers.DefaultContactComparator;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Autoboxing;
import com.openexchange.l10n.SuperCollator;
import com.openexchange.search.SearchTerm;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ContactSearchMultiplexer {
    private final ContactInterfaceDiscoveryService discoveryService;

    public ContactSearchMultiplexer(ContactInterfaceDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public SearchIterator<Contact> extendedSearch(ServerSession session, ContactSearchObject searchObj, int orderBy, Order order, String collation, int[] cols) throws OXException {
        int[] folders2 = searchObj.getFolders();
        int contextId = session.getContextId();
        LinkedList<SearchIterator<Contact>> searchIterators = new LinkedList<SearchIterator<Contact>>();
        if (null != folders2 && folders2.length > 0) {
            ArrayList<Integer> foldersForDefaultSearch = new ArrayList<Integer>(folders2.length);
            for (int folderId : folders2) {
                if (this.discoveryService.hasSpecificContactInterface(folderId, contextId)) {
                    ContactInterface contactInterface = this.discoveryService.newContactInterface(folderId, session);
                    searchObj.setFolders(folderId);
                    SearchIterator<Contact> iterator = contactInterface.getContactsByExtendedSearch(searchObj, orderBy, order, collation, cols);
                    searchIterators.add(iterator);
                    continue;
                }
                foldersForDefaultSearch.add(Autoboxing.I((int)folderId));
            }
            if (!foldersForDefaultSearch.isEmpty()) {
                searchObj.setFolders(foldersForDefaultSearch);
                ContactInterface defaultContactInterface = this.discoveryService.newDefaultContactInterface(session);
                SearchIterator<Contact> contactsByExtendedSearch = defaultContactInterface.getContactsByExtendedSearch(searchObj, orderBy, order, collation, cols);
                searchIterators.add(contactsByExtendedSearch);
            }
        } else {
            List<ContactInterfaceProviderRegistration> registrations = this.discoveryService.getRegistrations(contextId);
            for (ContactInterfaceProviderRegistration registration : registrations) {
                ContactInterface contactInterface = registration.newContactInterface(session);
                searchObj.setFolders(registration.getFolderId());
                SearchIterator<Contact> searchIterator = contactInterface.getContactsByExtendedSearch(searchObj, orderBy, order, collation, cols);
                searchIterators.add(searchIterator);
            }
            searchObj.clearFolders();
            ContactInterface defaultContactInterface = this.discoveryService.newDefaultContactInterface(session);
            SearchIterator<Contact> contactsByExtendedSearch = defaultContactInterface.getContactsByExtendedSearch(searchObj, orderBy, order, collation, cols);
            searchIterators.add(contactsByExtendedSearch);
        }
        if (searchIterators.size() == 1) {
            return (SearchIterator)searchIterators.get(0);
        }
        return new ContactMergerator((Comparator<Contact>)new DefaultContactComparator(orderBy, order, session.getUser().getLocale()), searchIterators);
    }

    public SearchIterator<Contact> extendedSearch(ServerSession session, SearchTerm<?> searchTerm, int orderBy, Order order, String collation, int[] cols) throws OXException {
        ContactSearchtermSqlConverter conv = new ContactSearchtermSqlConverter();
        conv.parse(searchTerm);
        List<String> folders2 = conv.getFolders();
        int contextId = session.getContextId();
        LinkedList<SearchIterator<Contact>> searchIterators = new LinkedList<SearchIterator<Contact>>();
        if (null != folders2 && folders2.size() > 0) {
            TIntArrayList foldersForDefaultSearch = new TIntArrayList(folders2.size());
            for (String folderStr : folders2) {
                int folderId = Integer.parseInt(folderStr);
                if (this.discoveryService.hasSpecificContactInterface(folderId, contextId)) {
                    ContactInterface contactInterface = this.discoveryService.newContactInterface(folderId, session);
                    SearchIterator<Contact> iterator = contactInterface.getContactsByExtendedSearch(searchTerm, orderBy, order, collation, cols);
                    searchIterators.add(iterator);
                    continue;
                }
                foldersForDefaultSearch.add(folderId);
            }
            if (!foldersForDefaultSearch.isEmpty()) {
                ContactInterface defaultContactInterface = this.discoveryService.newDefaultContactInterface(session);
                SearchIterator<Contact> contactsByExtendedSearch = defaultContactInterface.getContactsByExtendedSearch(searchTerm, orderBy, order, collation, cols);
                searchIterators.add(contactsByExtendedSearch);
            }
        } else {
            List<ContactInterfaceProviderRegistration> registrations = this.discoveryService.getRegistrations(contextId);
            for (ContactInterfaceProviderRegistration registration : registrations) {
                ContactInterface contactInterface = registration.newContactInterface(session);
                SearchIterator<Contact> searchIterator = contactInterface.getContactsByExtendedSearch(searchTerm, orderBy, order, collation, cols);
                searchIterators.add(searchIterator);
            }
            ContactInterface defaultContactInterface = this.discoveryService.newDefaultContactInterface(session);
            SearchIterator<Contact> contactsByExtendedSearch = defaultContactInterface.getContactsByExtendedSearch(searchTerm, orderBy, order, collation, cols);
            searchIterators.add(contactsByExtendedSearch);
        }
        if (searchIterators.size() == 1) {
            return (SearchIterator)searchIterators.get(0);
        }
        Comparator<Contact> comparator = this.getContactComparator(orderBy, order, collation, session.getUser().getLocale());
        return new ContactMergerator(comparator, searchIterators);
    }

    private Comparator<Contact> getContactComparator(int orderBy, Order order, String collation, Locale locale) {
        if (collation == null) {
            return new DefaultContactComparator(orderBy, order, locale);
        }
        SuperCollator myI18nMap = SuperCollator.get((String)collation);
        ContactField myField = ContactField.getByValue(orderBy);
        return new CollationContactComparator(myField, order, myI18nMap.getJavaLocale());
    }
}

