/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadSizeExceededException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractAttachmentAction
implements AJAXActionService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbstractAttachmentAction.class));
    protected static final AttachmentParser PARSER = new AttachmentParser();
    protected static final AttachmentBase ATTACHMENT_BASE = Attachment.ATTACHMENT_BASE;
    private final AtomicLong maxUploadSize = new AtomicLong(-2L);
    protected final ServiceLookup serviceLookup;

    protected AbstractAttachmentAction(ServiceLookup serviceLookup) {
        this.serviceLookup = serviceLookup;
    }

    protected int requireNumber(AJAXRequestData req, String parameter) throws OXException {
        String value = req.getParameter(parameter);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw AttachmentExceptionCodes.INVALID_REQUEST_PARAMETER.create(parameter, value);
        }
    }

    protected static void require(AJAXRequestData req, String ... parameters) throws OXException {
        for (String param : parameters) {
            if (req.getParameter(param) != null) continue;
            throw UploadException.UploadCode.MISSING_PARAM.create(param);
        }
    }

    protected void checkSize(long size) throws OXException {
        long maxUploadSize;
        if (this.maxUploadSize.get() == -2L) {
            long cur;
            long configuredSize = AttachmentConfig.getMaxUploadSize();
            while (!this.maxUploadSize.compareAndSet(cur = this.maxUploadSize.get(), configuredSize)) {
            }
        }
        if ((maxUploadSize = this.maxUploadSize.get()) == 0L) {
            return;
        }
        if (size > maxUploadSize) {
            throw UploadSizeExceededException.create(size, maxUploadSize, true);
        }
    }

    protected void rollback() {
        try {
            Attachment.ATTACHMENT_BASE.rollback();
        }
        catch (OXException e) {
            LOG.debug((Object)"Rollback failed.", (Throwable)e);
        }
    }
}

