/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum GroupExceptionCodes implements OXExceptionCode
{
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 1),
    SQL_ERROR("SQL Problem: \"%1$s\"", Category.CATEGORY_ERROR, 2),
    NULL("No group given.", Category.CATEGORY_ERROR, 3),
    MANDATORY_MISSING("The mandatory field %1$s is not defined.", Category.CATEGORY_USER_INPUT, 4),
    NOT_ALLOWED_SIMPLE_NAME("The simple name contains invalid characters: \"%1$s\".", Category.CATEGORY_USER_INPUT, 5),
    DUPLICATE("Another group with the same identifier name exists: %1$d.", Category.CATEGORY_USER_INPUT, 6),
    NOT_EXISTING_MEMBER("Group contains a not existing member %1$d.", Category.CATEGORY_USER_INPUT, 7),
    INVALID_DATA("Group contains invalid data: \"%1$s\".", Category.CATEGORY_USER_INPUT, 8),
    NO_CREATE_PERMISSION("You are not allowed to create groups.", Category.CATEGORY_PERMISSION_DENIED, 9),
    MODIFIED("Edit Conflict. Your change cannot be completed because somebody else has made a conflicting change to the same item. Please refresh or synchronize and try again.", Category.CATEGORY_CONFLICT, 10),
    NO_MODIFY_PERMISSION("You are not allowed to change groups.", Category.CATEGORY_PERMISSION_DENIED, 11),
    NO_DELETE_PERMISSION("You are not allowed to delete groups.", Category.CATEGORY_PERMISSION_DENIED, 12),
    NO_GROUP_DELETE("Group \"%1$s\" can not be deleted.", Category.CATEGORY_USER_INPUT, 13),
    NO_GROUP_UPDATE("Group \"%1$s\" can not be changed.", Category.CATEGORY_USER_INPUT, 14);

    private final String message;
    private final Category category;
    private final int detailNumber;

    private GroupExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public String getPrefix() {
        return "GRP";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

