/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.virtual.VirtualServiceRegistry;
import com.openexchange.folderstorage.virtual.sql.Delete;
import com.openexchange.folderstorage.virtual.sql.Insert;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;

public final class Update {
    private Update() {
    }

    public static void updateFolder(int cid, int tree, int user, Folder folder, Session session) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            Delete.deleteFolder(cid, tree, user, folder.getID(), false, session, con);
            Insert.insertFolder(cid, tree, user, folder, null, session, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }
}

