/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.davekoelle.AlphanumComparator;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Duplicate {
    private Duplicate() {
    }

    public static Map<String, List<String>> lookupDuplicateNames(int cid, int tree, int user) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            Map<String, List<String>> ret = Duplicate.lookupDuplicateNames(cid, tree, user, con);
            con.commit();
            Map<String, List<String>> map = ret;
            return map;
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, List<String>> lookupDuplicateNames(int cid, int tree, int user, Connection con) throws OXException {
        Iterator i$;
        HashMap<String, List<String>> name2ids;
        int pos;
        if (null == con) {
            return Duplicate.lookupDuplicateNames(cid, tree, user);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, String> name2parent;
            block20: {
                block19: {
                    stmt = con.prepareStatement("SELECT name, COUNT(name), parentId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? GROUP BY parentId, name");
                    pos = 1;
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, tree);
                    stmt.setInt(pos, user);
                    rs = stmt.executeQuery();
                    if (rs.next()) break block19;
                    Map<String, List<String>> map = Collections.emptyMap();
                    DBUtils.closeSQLStuff(rs, stmt);
                    DBUtils.closeSQLStuff(rs, stmt);
                    return map;
                }
                name2parent = new HashMap<String, String>();
                do {
                    if (rs.getInt(2) <= 1) continue;
                    name2parent.put(rs.getString(1), rs.getString(3));
                } while (rs.next());
                if (!name2parent.isEmpty()) break block20;
                Map<String, List<String>> map = Collections.emptyMap();
                {
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                DBUtils.closeSQLStuff(rs, stmt);
                return map;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            name2ids = new HashMap<String, List<String>>();
            i$ = name2parent.entrySet().iterator();
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            try {
                stmt = con.prepareStatement("SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND name = ? AND parentId = ?");
                String name = (String)entry.getKey();
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos++, name);
                stmt.setString(pos++, (String)entry.getValue());
                rs = stmt.executeQuery();
                if (!rs.next()) continue;
                ArrayList<String> folderIds = new ArrayList<String>(4);
                do {
                    folderIds.add(rs.getString(1));
                } while (rs.next());
                Collections.sort(folderIds, new AlphanumComparator(Locale.US));
                folderIds.remove(0);
                name2ids.put(name, folderIds);
            }
            finally {
                DBUtils.closeSQLStuff(rs, stmt);
            }
        }
        for (Map.Entry entry : name2ids.entrySet()) {
            List folderIds = (List)entry.getValue();
            int sz = folderIds.size();
            for (int i = 0; i < sz; ++i) {
                Delete.deleteFolder(cid, tree, user, (String)folderIds.get(i), false, false, con);
            }
        }
        HashMap<String, List<String>> hashMap = name2ids;
        DBUtils.closeSQLStuff(rs, stmt);
        return hashMap;
    }
}

