/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.groupware.contact.helpers.ContactField;
import java.util.HashSet;

public class QueryFields {
    private boolean needsAttachmentInfo;
    private final ContactField[] queriedFields;

    public QueryFields() {
        this(null);
    }

    public QueryFields(ContactField[] fields) {
        this(fields, null);
    }

    public QueryFields(ContactField[] fields, ContactField[] allowedFields) {
        if (null == fields) {
            if (null == allowedFields) {
                this.queriedFields = ContactField.values();
                this.needsAttachmentInfo = true;
            } else {
                this.needsAttachmentInfo = false;
                HashSet<ContactField> preparedFields = new HashSet<ContactField>();
                for (ContactField field : allowedFields) {
                    preparedFields.add(field);
                    if (!ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT.equals((Object)field)) continue;
                    this.needsAttachmentInfo = true;
                    preparedFields.add(ContactField.NUMBER_OF_ATTACHMENTS);
                }
                this.queriedFields = preparedFields.toArray(new ContactField[preparedFields.size()]);
            }
        } else {
            this.needsAttachmentInfo = false;
            HashSet<ContactField> preparedFields = new HashSet<ContactField>();
            if (null == allowedFields) {
                preparedFields.add(ContactField.CREATED_BY);
                preparedFields.add(ContactField.PRIVATE_FLAG);
                preparedFields.add(ContactField.FOLDER_ID);
                preparedFields.add(ContactField.OBJECT_ID);
                preparedFields.add(ContactField.CONTEXTID);
            }
            for (ContactField field : fields) {
                if (null != allowedFields && !QueryFields.contains(allowedFields, field)) continue;
                preparedFields.add(field);
                if (!ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT.equals((Object)field)) continue;
                this.needsAttachmentInfo = true;
                preparedFields.add(ContactField.NUMBER_OF_ATTACHMENTS);
            }
            this.queriedFields = preparedFields.toArray(new ContactField[preparedFields.size()]);
        }
    }

    private static boolean contains(ContactField[] fields, ContactField field) {
        for (ContactField presentField : fields) {
            if (!presentField.equals((Object)field)) continue;
            return true;
        }
        return false;
    }

    public boolean needsAttachmentInfo() {
        return this.needsAttachmentInfo;
    }

    public ContactField[] getFields() {
        return this.queriedFields;
    }
}

