/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.json.ConfigAJAXRequest;
import com.openexchange.config.json.actions.AbstractConfigAction;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="config/path", description="Set configuration data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="The new value of the node specified by path.")
public final class PUTAction
extends AbstractConfigAction {
    public PUTAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ConfigAJAXRequest req) throws OXException, JSONException {
        String path;
        ServerSession session = req.getSession();
        String value = req.getData().toString();
        if (value.length() > 0 && value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if ((path = req.getRequest().getSerlvetRequestURI()).length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        SettingStorage stor = SettingStorage.getInstance(session);
        Setting setting = ConfigTree.getInstance().getSettingByPath(path);
        setting.setSingleValue(value);
        UserSettingMailStorage.getInstance().removeUserSettingMail(session.getUserId(), session.getContext());
        this.saveSettingWithSubs(stor, setting);
        return PUTAction.getJSONNullResult();
    }

    private void saveSettingWithSubs(SettingStorage storage, Setting setting) throws OXException, JSONException {
        if (setting.isLeaf()) {
            String value = (String)setting.getSingleValue();
            if (null != value && value.length() > 0 && '[' == value.charAt(0)) {
                JSONArray array = new JSONArray(value);
                if (array.length() == 0) {
                    setting.setEmptyMultiValue();
                } else {
                    for (int i = 0; i < array.length(); ++i) {
                        setting.addMultiValue(array.getString(i));
                    }
                }
                setting.setSingleValue(null);
            }
            storage.save(setting);
        } else {
            JSONObject json = new JSONObject(setting.getSingleValue().toString());
            Iterator iter = json.keys();
            OXException exc = null;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Setting sub = ConfigTree.getSettingByPath(setting, new String[]{key});
                sub.setSingleValue(json.getString(key));
                try {
                    this.saveSettingWithSubs(storage, sub);
                }
                catch (OXException e) {
                    exc = e;
                }
            }
            if (null != exc) {
                throw exc;
            }
        }
    }
}

