/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.charset;

import com.openexchange.charset.AliasCharset;
import com.openexchange.charset.StartsWithCharset;
import com.openexchange.log.LogFactory;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;

public final class CustomCharsetProvider
extends CharsetProvider {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CustomCharsetProvider.class));
    private static volatile ConcurrentMap<String, Charset> name2charset;
    private static volatile ConcurrentMap<String, Charset> startsWith2charset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initCharsetMap() {
        if (name2charset != null) return;
        Class<CustomCharsetProvider> clazz = CustomCharsetProvider.class;
        synchronized (CustomCharsetProvider.class) {
            if (name2charset != null) return;
            name2charset = new ConcurrentHashMap<String, Charset>(8);
            startsWith2charset = new ConcurrentHashMap<String, Charset>(8);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseCharsetMap() {
        if (name2charset == null) return;
        Class<CustomCharsetProvider> clazz = CustomCharsetProvider.class;
        synchronized (CustomCharsetProvider.class) {
            if (name2charset == null) return;
            name2charset = null;
            startsWith2charset = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public boolean addAliasCharset(String delegateName, String canonicalName, String ... aliases) {
        Charset charset;
        try {
            charset = Charset.forName(delegateName);
        }
        catch (IllegalCharsetNameException e) {
            LOG.error((Object)("Illegal charset name \"" + e.getCharsetName() + '\"'), (Throwable)e);
            return false;
        }
        catch (UnsupportedCharsetException e) {
            LOG.error((Object)("Detected no support for charset \"" + e.getCharsetName() + '\"'), (Throwable)e);
            return false;
        }
        return this.addAliasCharset(charset, canonicalName, aliases);
    }

    public boolean addAliasCharset(Charset delegate, String canonicalName, String ... aliases) {
        AliasCharset aliasCharset = new AliasCharset(canonicalName, null == aliases || aliases.length == 0 ? null : aliases, delegate);
        String key = aliasCharset.name().toLowerCase();
        ConcurrentMap<String, Charset> map = name2charset;
        if (null == map) {
            return false;
        }
        boolean added = null == map.putIfAbsent(key, aliasCharset);
        Set<String> aliasSet = aliasCharset.aliases();
        if (added && !aliasSet.isEmpty()) {
            ArrayList<String> addedKeys = new ArrayList<String>(aliasSet.size() + 1);
            Iterator<String> iter = aliasSet.iterator();
            while (added && iter.hasNext()) {
                addedKeys.add(key);
                key = iter.next().toLowerCase();
                added = null == map.putIfAbsent(key, aliasCharset);
            }
            if (!added) {
                for (String removeMe : addedKeys) {
                    map.remove(removeMe);
                }
            }
        }
        return added;
    }

    public boolean addStartsWithCharset(String delegateName, String startsWithName) {
        Charset charset;
        try {
            charset = Charset.forName(delegateName);
        }
        catch (IllegalCharsetNameException e) {
            LOG.error((Object)("Illegal charset name \"" + e.getCharsetName() + '\"'), (Throwable)e);
            return false;
        }
        catch (UnsupportedCharsetException e) {
            LOG.error((Object)("Detected no support for charset \"" + e.getCharsetName() + '\"'), (Throwable)e);
            return false;
        }
        return this.addStartsWithCharset(charset, startsWithName);
    }

    public boolean addStartsWithCharset(Charset delegate, String startsWithName) {
        ConcurrentMap<String, Charset> startsWithMap = startsWith2charset;
        if (null == startsWithMap) {
            return false;
        }
        StartsWithCharset startsWithCharset = new StartsWithCharset(startsWithName, delegate);
        return null == startsWithMap.putIfAbsent(startsWithName.toLowerCase(), startsWithCharset);
    }

    @Override
    public Charset charsetForName(String charsetName) {
        ConcurrentMap<String, Charset> map = name2charset;
        if (null == map) {
            return null;
        }
        Charset retval = (Charset)map.get(charsetName.toLowerCase());
        if (null != retval) {
            return retval;
        }
        ConcurrentMap<String, Charset> startsWithMap = startsWith2charset;
        if (!startsWithMap.isEmpty()) {
            Iterator iter = startsWithMap.entrySet().iterator();
            while (null == retval && iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!charsetName.toLowerCase().startsWith((String)entry.getKey())) continue;
                retval = (Charset)entry.getValue();
            }
        }
        return retval;
    }

    @Override
    public Iterator<Charset> charsets() {
        ConcurrentMap<String, Charset> map = name2charset;
        if (null == map) {
            return Collections.emptyList().iterator();
        }
        HashSet set = new HashSet(map.values());
        set.addAll(startsWith2charset.values());
        return CustomCharsetProvider.unmodifiableIterator(set.iterator());
    }

    private static <T> Iterator<T> unmodifiableIterator(final Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

