/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.fields.ResponseFields;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.Categories;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.Log;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;

public final class ResponseWriter {
    private static final Set<String> RESERVED_IDENTIFIERS = ResponseFields.RESERVED_IDENTIFIERS;
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static volatile Boolean includeStackTraceOnError;

    private ResponseWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean includeStackTraceOnError() {
        Boolean b = includeStackTraceOnError;
        if (null != b) return b;
        Class<ResponseWriter> clazz = ResponseWriter.class;
        synchronized (ResponseWriter.class) {
            b = includeStackTraceOnError;
            if (null != b) return b;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            includeStackTraceOnError = b = Boolean.valueOf(null != service && service.getBoolProperty("com.openexchange.ajax.response.includeStackTraceOnError", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    public static JSONObject getJSON(Response response) throws JSONException {
        JSONObject json = new JSONObject();
        ResponseWriter.write(response, json, DEFAULT_LOCALE);
        return json;
    }

    public static JSONObject getJSON(Response response, Locale locale) throws JSONException {
        JSONObject json = new JSONObject();
        ResponseWriter.write(response, json, locale);
        return json;
    }

    public static void write(Response response, JSONObject json) throws JSONException {
        ResponseWriter.write(response, json, DEFAULT_LOCALE);
    }

    public static void write(Response response, JSONObject json, Locale locale) throws JSONException {
        if (null != response.getData()) {
            json.put("data", response.getData());
        }
        if (null != response.getTimestamp()) {
            json.put("timestamp", response.getTimestamp().getTime());
        }
        List<OXException> warnings = response.getWarnings();
        OXException exception = response.getException();
        if (null == exception) {
            if (null != warnings && !warnings.isEmpty()) {
                ResponseWriter.addException(json, warnings.get(0), locale);
            }
        } else {
            ResponseWriter.addException(json, exception, locale);
        }
        ResponseWriter.addWarnings(json, warnings, locale);
        ResponseWriter.addProperties(json, response.getProperties());
    }

    public static void addProperties(JSONObject json, Map<String, Object> properties) throws JSONException {
        if (null == properties || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            if (null != name && !RESERVED_IDENTIFIERS.contains(name)) {
                Object value = entry.getValue();
                if (null == value) continue;
                json.put(name, value);
                continue;
            }
            Log.loggerFor(ResponseWriter.class).warn((Object)("Response property discarded. Illegal property name: " + name == null ? "null" : name));
        }
    }

    public static void addWarning(JSONObject json, OXException warning, Locale locale) throws JSONException {
        if (null == warning) {
            return;
        }
        JSONObject jsonWarning = new JSONObject();
        ResponseWriter.addException(jsonWarning, warning.setCategory(Category.CATEGORY_WARNING), locale);
        json.put("warnings", (Object)jsonWarning);
    }

    public static void addWarnings(JSONObject json, List<OXException> warnings) throws JSONException {
        ResponseWriter.addWarnings(json, warnings, DEFAULT_LOCALE);
    }

    public static void addWarnings(JSONObject json, List<OXException> warnings, Locale locale) throws JSONException {
        if (null == warnings || warnings.isEmpty()) {
            return;
        }
        if (1 == warnings.size()) {
            JSONObject jsonWarning = new JSONObject();
            OXException warning = warnings.get(0).setCategory(Category.CATEGORY_WARNING);
            ResponseWriter.addException(jsonWarning, warning, locale);
            json.put("warnings", (Object)jsonWarning);
            if (!json.hasAndNotNull("error")) {
                ResponseWriter.addException(json, warning, locale);
            }
        } else {
            JSONArray jsonArray = new JSONArray();
            for (OXException warning : warnings) {
                JSONObject jsonWarning = new JSONObject();
                ResponseWriter.addException(jsonWarning, warning.setCategory(Category.CATEGORY_WARNING), locale);
                jsonArray.put((Object)jsonWarning);
            }
            json.put("warnings", (Object)jsonArray);
            if (!warnings.isEmpty() && !json.hasAndNotNull("error")) {
                ResponseWriter.addException(json, warnings.get(0).setCategory(Category.CATEGORY_WARNING), locale);
            }
        }
    }

    public static void addException(JSONObject json, OXException exception) throws JSONException {
        ResponseWriter.addException(json, exception, DEFAULT_LOCALE);
    }

    public static void addException(JSONObject json, OXException exception, Locale locale) throws JSONException {
        int number;
        JSONArray jArray;
        json.put("error", (Object)exception.getDisplayMessage(locale));
        Object[] args = exception.getLogArgs();
        if (null == args || 0 == args.length) {
            args = exception.getDisplayArgs();
        }
        if (null == args || 0 == args.length) {
            json.put("error_params", (Object)new JSONArray());
        } else {
            jArray = new JSONArray();
            for (Object arg : args) {
                jArray.put(arg);
            }
            json.put("error_params", (Object)jArray);
        }
        List categories = exception.getCategories();
        if (1 == categories.size()) {
            json.put("categories", (Object)((Category)categories.get(0)).toString());
        } else {
            jArray = new JSONArray();
            for (Category category : categories) {
                jArray.put((Object)category.toString());
            }
            json.put("categories", (Object)jArray);
        }
        if (!categories.isEmpty() && (number = Categories.getFormerCategoryNumber((Category)((Category)categories.get(0)))) > 0) {
            json.put("category", number);
        }
        json.put("code", (Object)exception.getErrorCode());
        json.put("error_id", (Object)exception.getExceptionId());
        ResponseWriter.toJSON(json, exception.getProblematics());
        if (Category.CATEGORY_TRUNCATED.equals(exception.getCategory())) {
            ResponseWriter.addTruncated(json, exception.getProblematics());
        }
        if (ResponseWriter.includeStackTraceOnError()) {
            JSONArray jsonStack = new JSONArray();
            jsonStack.put((Object)exception.getSoleMessage());
            StackTraceElement[] traceElements = exception.getStackTrace();
            Throwable cause = exception;
            StringBuilder tmp = new StringBuilder(64);
            while (null != traceElements && traceElements.length > 0) {
                for (StackTraceElement stackTraceElement : traceElements) {
                    tmp.setLength(0);
                    ResponseWriter.writeElementTo(stackTraceElement, tmp);
                    jsonStack.put((Object)tmp.toString());
                }
                if (null == (cause = cause.getCause())) {
                    traceElements = null;
                    continue;
                }
                tmp.setLength(0);
                jsonStack.put((Object)tmp.append("Caused by: ").append(cause.getClass().getName()).append(": ").append(cause.getMessage()).toString());
                traceElements = cause.getStackTrace();
            }
            json.put("error_stack", (Object)jsonStack);
        }
    }

    private static void writeElementTo(StackTraceElement element, StringBuilder sb) {
        sb.append(element.getClassName()).append('.').append(element.getMethodName());
        if (element.isNativeMethod()) {
            sb.append("(Native Method)");
        } else {
            String fileName = element.getFileName();
            if (null != fileName) {
                sb.append('(').append(fileName);
                int lineNumber = element.getLineNumber();
                if (lineNumber >= 0) {
                    sb.append(':').append(lineNumber);
                }
                sb.append(')');
            } else {
                sb.append("(Unknown Source)");
            }
        }
    }

    private static void toJSON(JSONObject json, OXException.ProblematicAttribute[] problematics) throws JSONException {
        JSONArray array = new JSONArray();
        for (OXException.ProblematicAttribute problematic : problematics) {
            array.put((Object)ResponseWriter.toJSON(problematic));
        }
        if (array.length() > 0) {
            json.put("problematic", (Object)array);
        }
    }

    public static JSONObject toJSON(OXException.ProblematicAttribute problematic) throws JSONException {
        if (problematic instanceof OXException.Truncated) {
            return ResponseWriter.toJSON((OXException.Truncated)problematic);
        }
        if (problematic instanceof OXException.Parsing) {
            return ResponseWriter.toJSON((OXException.Parsing)problematic);
        }
        return new JSONObject();
    }

    public static JSONObject toJSON(OXException.Truncated truncated) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", truncated.getId());
        json.put("length", truncated.getLength());
        json.put("max_size", truncated.getMaxSize());
        return json;
    }

    public static JSONObject toJSON(OXException.Parsing parsing) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", (Object)parsing.getAttribute());
        return json;
    }

    private static void addTruncated(JSONObject json, OXException.ProblematicAttribute[] problematics) throws JSONException {
        JSONArray array = new JSONArray();
        for (OXException.ProblematicAttribute problematic : problematics) {
            if (!OXException.Truncated.class.isAssignableFrom(problematic.getClass())) continue;
            array.put(((OXException.Truncated)problematic).getId());
        }
        json.put("truncated", (Object)array);
    }

    public static void write(Response response, JSONWriter writer) throws JSONException {
        writer.object();
        JSONObject json = new JSONObject();
        ResponseWriter.write(response, json);
        Set entrySet = json.entrySet();
        int len = entrySet.size();
        Iterator iter = entrySet.iterator();
        for (int i = 0; i < len; ++i) {
            Map.Entry e = (Map.Entry)iter.next();
            writer.key((String)e.getKey()).value(e.getValue());
        }
        writer.endObject();
    }

    public static void write(Response response, Writer writer) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        ResponseWriter.write(response, json);
        try {
            json.write(writer);
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static void writeWarnings(List<OXException> warnings, JSONWriter writer) throws JSONException {
        ResponseWriter.writeWarnings(warnings, writer, DEFAULT_LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWarnings(List<OXException> warnings, JSONWriter writer, Locale locale) throws JSONException {
        if (null == warnings || warnings.isEmpty()) {
            return;
        }
        writer.key("warnings");
        if (1 == warnings.size()) {
            JSONObject json;
            JSONValue jv;
            OXException warning = warnings.get(0);
            writer.object();
            try {
                ResponseWriter.writeException(warning.setCategory(Category.CATEGORY_WARNING), writer, locale);
            }
            finally {
                writer.endObject();
            }
            if (writer instanceof OXJSONWriter && (jv = ((OXJSONWriter)writer).getObject()).isObject() && !(json = (JSONObject)jv).hasAndNotNull("error")) {
                ResponseWriter.addException(json, warning, locale);
            }
        } else {
            JSONObject json;
            JSONValue jv;
            writer.array();
            try {
                for (OXException warning : warnings) {
                    writer.object();
                    try {
                        ResponseWriter.writeException(warning.setCategory(Category.CATEGORY_WARNING), writer, locale);
                    }
                    finally {
                        writer.endObject();
                    }
                }
            }
            finally {
                writer.endArray();
            }
            if (!warnings.isEmpty() && writer instanceof OXJSONWriter && (jv = ((OXJSONWriter)writer).getObject()).isObject() && !(json = (JSONObject)jv).hasAndNotNull("error")) {
                ResponseWriter.addException(json, warnings.get(0), locale);
            }
        }
    }

    public static void writeException(OXException exc, JSONWriter writer) throws JSONException {
        ResponseWriter.writeException(exc, writer, DEFAULT_LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeException(OXException exc, JSONWriter writer, Locale locale) throws JSONException {
        int number;
        writer.key("error").value((Object)exc.getDisplayMessage(locale));
        Object[] args = exc.getLogArgs();
        if (null == args || 0 == args.length) {
            args = exc.getDisplayArgs();
        }
        if (null == args || 0 == args.length) {
            writer.key("error_params").value((Object)new JSONArray());
        } else {
            JSONArray jArray = new JSONArray();
            for (Object arg : args) {
                jArray.put(arg);
            }
            writer.key("error_params").value((Object)jArray);
        }
        List categories = exc.getCategories();
        if (1 == categories.size()) {
            writer.key("categories").value((Object)((Category)categories.get(0)).toString());
        } else {
            writer.key("categories");
            writer.array();
            try {
                for (Category category : categories) {
                    writer.value((Object)category.toString());
                }
            }
            finally {
                writer.endArray();
            }
        }
        if (!categories.isEmpty() && (number = Categories.getFormerCategoryNumber((Category)((Category)categories.get(0)))) > 0) {
            writer.key("category").value((long)number);
        }
        writer.key("code").value((Object)exc.getErrorCode());
        writer.key("error_id").value((Object)exc.getExceptionId());
        ResponseWriter.writeProblematic(exc, writer);
        ResponseWriter.writeTruncated(exc, writer);
        if (ResponseWriter.includeStackTraceOnError()) {
            writer.key("error_stack");
            writer.array();
            try {
                writer.value((Object)exc.getSoleMessage());
                StackTraceElement[] traceElements = exc.getStackTrace();
                if (null != traceElements && traceElements.length > 0) {
                    StringBuilder tmp = new StringBuilder(64);
                    for (StackTraceElement stackTraceElement : traceElements) {
                        tmp.setLength(0);
                        ResponseWriter.writeElementTo(stackTraceElement, tmp);
                        writer.value((Object)tmp.toString());
                    }
                }
            }
            finally {
                writer.endArray();
            }
        }
    }

    private static void writeProblematic(OXException exc, JSONWriter writer) throws JSONException {
        OXException.ProblematicAttribute[] problematics = exc.getProblematics();
        if (problematics.length > 0) {
            writer.key("problematic");
            writer.array();
            for (OXException.ProblematicAttribute problematic : problematics) {
                writer.value((Object)ResponseWriter.toJSON(problematic));
            }
            writer.endArray();
        }
    }

    private static void writeTruncated(OXException exc, JSONWriter writer) throws JSONException {
        OXException.ProblematicAttribute[] problematics = exc.getProblematics();
        if (problematics.length > 0) {
            JSONArray array = new JSONArray();
            for (OXException.ProblematicAttribute problematic : problematics) {
                if (!(problematic instanceof OXException.Truncated)) continue;
                array.put(((OXException.Truncated)problematic).getId());
            }
            writer.key("truncated").value((Object)array);
        }
    }
}

