/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class LoginWriter {
    private static final Locale DEFAULT_LOCALE = Locale.US;

    public void writeLogin(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result, json);
    }

    public void writeLogin(Session session, JSONObject json) throws JSONException {
        LoginWriter.write(session, json);
    }

    public static void write(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result.getSession(), json, result.warnings(), result.getUser().getLocale());
    }

    public static void write(Session session, JSONObject json) throws JSONException {
        LoginWriter.write(session, json, Collections.<OXException>emptyList(), null);
    }

    private static void write(Session session, JSONObject json, Collection<OXException> warnings, Locale locale) throws JSONException {
        json.put("session", (Object)session.getSessionID());
        json.put("random", (Object)session.getRandomToken());
        json.put("user", (Object)session.getLogin());
        json.put("user_id", session.getUserId());
        if (null != warnings && !warnings.isEmpty()) {
            OXJSONWriter writer = new OXJSONWriter(json);
            ResponseWriter.writeWarnings((List<OXException>)(warnings instanceof List ? (List<Object>)warnings : new ArrayList<OXException>(warnings)), writer, locale == null ? DEFAULT_LOCALE : locale);
        }
    }
}

