/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.osgi.AbstractSessionServletActivator;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXResultDecoratorRegistry;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.DefaultConverter;
import com.openexchange.ajax.requesthandler.DefaultDispatcher;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.BasicTypeAPIResultConverter;
import com.openexchange.ajax.requesthandler.converters.BasicTypeJsonConverter;
import com.openexchange.ajax.requesthandler.converters.DebugConverter;
import com.openexchange.ajax.requesthandler.converters.preview.DownloadPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.FilteredHTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.HTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.MailFilteredHTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.MailTextPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewImageResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.TextPreviewResultConverter;
import com.openexchange.ajax.requesthandler.customizer.ConversionCustomizer;
import com.openexchange.ajax.requesthandler.osgi.DecoratingAJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.osgi.OSGiAJAXResultDecoratorRegistry;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.PreviewResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.StringResponseRenderer;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.osgi.SimpleRegistryListener;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.images.ImageScalingService;
import com.openexchange.tools.session.ServerSession;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DispatcherActivator
extends AbstractSessionServletActivator {
    private final Set<String> servlets = new HashSet<String>();
    private volatile OSGiAJAXResultDecoratorRegistry decoratorRegistry;
    private volatile String prefix;

    protected void startBundle() throws Exception {
        this.prefix = ((DispatcherPrefixService)this.getService(DispatcherPrefixService.class)).getPrefix();
        final DefaultDispatcher dispatcher = new DefaultDispatcher();
        final DefaultConverter defaultConverter = new DefaultConverter();
        this.registerService(Converter.class, defaultConverter);
        defaultConverter.addConverter(new DebugConverter());
        for (ResultConverter converter : BasicTypeAPIResultConverter.CONVERTERS) {
            defaultConverter.addConverter(converter);
        }
        for (ResultConverter converter : BasicTypeJsonConverter.CONVERTERS) {
            defaultConverter.addConverter(converter);
        }
        TextPreviewResultConverter textPreviewResultConverter = new TextPreviewResultConverter();
        FilteredHTMLPreviewResultConverter filteredHTMLPreviewResultConverter = new FilteredHTMLPreviewResultConverter();
        defaultConverter.addConverter(new HTMLPreviewResultConverter());
        defaultConverter.addConverter(textPreviewResultConverter);
        defaultConverter.addConverter(filteredHTMLPreviewResultConverter);
        defaultConverter.addConverter(new DownloadPreviewResultConverter());
        defaultConverter.addConverter(new PreviewImageResultConverter());
        defaultConverter.addConverter(new MailTextPreviewResultConverter(textPreviewResultConverter));
        defaultConverter.addConverter(new MailFilteredHTMLPreviewResultConverter(filteredHTMLPreviewResultConverter));
        this.track(ResultConverter.class, (SimpleRegistryListener)new SimpleRegistryListener<ResultConverter>(){

            public void added(ServiceReference<ResultConverter> ref, ResultConverter thing) {
                defaultConverter.addConverter(thing);
            }

            public void removed(ServiceReference<ResultConverter> ref, ResultConverter thing) {
                defaultConverter.removeConverter(thing);
            }
        });
        OSGiAJAXResultDecoratorRegistry decoratorRegistry = new OSGiAJAXResultDecoratorRegistry();
        decoratorRegistry.start(this.context);
        this.decoratorRegistry = decoratorRegistry;
        this.registerService(AJAXResultDecoratorRegistry.class, decoratorRegistry);
        ServerServiceRegistry.getInstance().addService(AJAXResultDecoratorRegistry.class, decoratorRegistry);
        DecoratingAJAXActionCustomizer.REGISTRY_REF.set(decoratorRegistry);
        dispatcher.addCustomizer(new ConversionCustomizer(defaultConverter));
        dispatcher.addCustomizer(new AJAXActionCustomizerFactory(){

            @Override
            public AJAXActionCustomizer createCustomizer(AJAXRequestData request, ServerSession session) {
                return DecoratingAJAXActionCustomizer.getInstance();
            }
        });
        final DispatcherServlet servlet = new DispatcherServlet();
        DispatcherServlet.setDispatcher(dispatcher);
        Multiple.setDispatcher(dispatcher);
        DispatcherServlet.registerRenderer(new APIResponseRenderer());
        final FileResponseRenderer fileRenderer = new FileResponseRenderer();
        DispatcherServlet.registerRenderer(fileRenderer);
        DispatcherServlet.registerRenderer(new StringResponseRenderer());
        DispatcherServlet.registerRenderer(new PreviewResponseRenderer());
        this.track(ResponseRenderer.class, (SimpleRegistryListener)new SimpleRegistryListener<ResponseRenderer>(){

            public void added(ServiceReference<ResponseRenderer> ref, ResponseRenderer thing) {
                DispatcherServlet.registerRenderer(thing);
            }

            public void removed(ServiceReference<ResponseRenderer> ref, ResponseRenderer thing) {
                DispatcherServlet.unregisterRenderer(thing);
            }
        });
        this.track(AJAXActionServiceFactory.class, (SimpleRegistryListener)new SimpleRegistryListener<AJAXActionServiceFactory>(){

            public void added(ServiceReference<AJAXActionServiceFactory> ref, AJAXActionServiceFactory service) {
                String module = (String)ref.getProperty("module");
                dispatcher.register(module, service);
                if (!DispatcherActivator.this.servlets.contains(module)) {
                    DispatcherActivator.this.registerSessionServlet(DispatcherActivator.this.prefix + module, servlet, new String[0]);
                    DispatcherActivator.this.servlets.add(module);
                }
            }

            public void removed(ServiceReference<AJAXActionServiceFactory> ref, AJAXActionServiceFactory service) {
                String module = (String)ref.getProperty("module");
                if (DispatcherActivator.this.servlets.contains(module)) {
                    DispatcherActivator.this.unregisterServlet(DispatcherActivator.this.prefix + module);
                    DispatcherActivator.this.servlets.remove(module);
                }
            }
        });
        this.track(ImageScalingService.class, (SimpleRegistryListener)new SimpleRegistryListener<ImageScalingService>(){

            public void added(ServiceReference<ImageScalingService> ref, ImageScalingService thing) {
                fileRenderer.setScaler(thing);
            }

            public void removed(ServiceReference<ImageScalingService> ref, ImageScalingService thing) {
                fileRenderer.setScaler(null);
            }
        });
        this.openTrackers();
        this.registerService(Dispatcher.class, dispatcher);
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
        DispatcherServlet.clearRenderer();
        DispatcherServlet.setDispatcher(null);
        DispatcherServlet.setPrefix(null);
        OSGiAJAXResultDecoratorRegistry decoratorRegistry = this.decoratorRegistry;
        if (null != decoratorRegistry) {
            decoratorRegistry.stop();
            this.decoratorRegistry = null;
        }
        ServerServiceRegistry.getInstance().removeService(AJAXResultDecoratorRegistry.class);
        DecoratingAJAXActionCustomizer.REGISTRY_REF.set(null);
        this.unregisterServlet(this.prefix);
        this.prefix = null;
        ServerServiceRegistry.getInstance().removeService(DispatcherPrefixService.class);
        ImageMatcher.setPrefixService(null);
        Multiple.setDispatcher(null);
    }

    public void forgetTracker(ServiceTracker<?, ?> tracker) {
        super.forgetTracker(tracker);
    }

    public void rememberTracker(ServiceTracker<?, ?> tracker) {
        super.rememberTracker(tracker);
    }

    @Override
    protected Class<?>[] getAdditionalNeededServices() {
        return new Class[]{DispatcherPrefixService.class};
    }
}

