/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;

public class PreviewImageResultConverter
extends AbstractPreviewResultConverter {
    @Override
    public String getOutputFormat() {
        return "preview_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Object resultObject = result.getResultObject();
        if (!(resultObject instanceof IFileHolder)) {
            throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
        }
        IFileHolder fileHolder = (IFileHolder)resultObject;
        PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
        DataProperties dataProperties = new DataProperties(4);
        dataProperties.put("com.openexchange.conversion.content-type", fileHolder.getContentType());
        dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
        dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
        dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
        PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)fileHolder.getStream(), dataProperties), this.getOutput(), (Session)session, 1);
        requestData.setFormat("file");
        InputStream thumbnail = previewDocument.getThumbnail();
        String fileName = (String)previewDocument.getMetaData().get("resourcename");
        FileHolder responseFileHolder = new FileHolder(thumbnail, -1L, "image/jpeg", fileName);
        result.setResultObject(responseFileHolder, "file");
    }
}

