/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.OutputStream;

abstract class AbstractMailPreviewResultConverter
implements ResultConverter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbstractMailPreviewResultConverter.class));
    protected final AbstractPreviewResultConverter resultConverter;

    protected AbstractMailPreviewResultConverter(AbstractPreviewResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    public String getInputFormat() {
        return "mail";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public String getOutputFormat() {
        return this.resultConverter.getOutputFormat();
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        MailMessage mail = (MailMessage)result.getResultObject();
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
        try {
            mail.writeTo((OutputStream)baos);
        }
        catch (OXException e) {
            if (!MailExceptionCode.NO_CONTENT.equals(e)) {
                throw e;
            }
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            baos.reset();
        }
        mail.prepareForCaching();
        ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(baos.toByteArray());
        fileHolder.setContentType("application/octet-stream");
        fileHolder.setName(mail.getSubject() + ".eml");
        result.setResultObject(fileHolder, "file");
        result.setParameter("__mail", mail);
        this.resultConverter.convert(requestData, result, session, converter);
    }
}

