/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherServlet
extends SessionServlet {
    private static final long serialVersionUID = -8060034833311074781L;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DispatcherServlet.class));
    private static final Session NO_SESSION = new SessionObject("");
    private static final AtomicReference<Dispatcher> DISPATCHER = new AtomicReference();
    private static final List<ResponseRenderer> RESPONSE_RENDERERS = new CopyOnWriteArrayList<ResponseRenderer>();
    protected final AJAXRequestDataTools defaultRequestDataTools = AJAXRequestDataTools.getInstance();
    private static final AJAXRequestResult.ResultType ETAG = AJAXRequestResult.ResultType.ETAG;

    public static void setDispatcher(Dispatcher dispatcher) {
        DISPATCHER.set(dispatcher);
    }

    public static Dispatcher getDispatcher() {
        return DISPATCHER.get();
    }

    public static void setPrefix(String prefix) {
        Dispatcher.PREFIX.set(prefix);
    }

    public static String getPrefix() {
        return Dispatcher.PREFIX.get();
    }

    protected AJAXRequestDataTools getAjaxRequestDataTools() {
        return this.defaultRequestDataTools;
    }

    public static void registerRenderer(ResponseRenderer renderer) {
        RESPONSE_RENDERERS.add(renderer);
    }

    public static void unregisterRenderer(ResponseRenderer renderer) {
        RESPONSE_RENDERERS.remove(renderer);
    }

    public static void clearRenderer() {
        RESPONSE_RENDERERS.clear();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean preferStream) throws IOException {
        httpResponse.setStatus(200);
        httpResponse.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(httpResponse);
        String action = httpRequest.getParameter("action");
        AJAXState state = null;
        Dispatcher dispatcher = DISPATCHER.get();
        try {
            AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
            String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), httpRequest);
            String action2 = requestDataTools.getAction(httpRequest);
            ServerSession session = DispatcherServlet.getSessionObject((ServletRequest)httpRequest, dispatcher.mayUseFallbackSession(module, action2));
            if (session == null && dispatcher.mayOmitSession(module, action2)) {
                session = this.fakeSession();
            }
            if (null == session) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            }
            AJAXRequestData requestData = requestDataTools.parseRequest(httpRequest, preferStream, Tools.isMultipartContent(httpRequest), session, Dispatcher.PREFIX.get());
            requestData.setSession(session);
            state = dispatcher.begin();
            AJAXRequestResult result = dispatcher.perform(requestData, state, session);
            if (ETAG.equals((Object)result.getType())) {
                httpResponse.setStatus(304);
                long expires = result.getExpires();
                Tools.setETag(requestData.getETag(), expires > 0L ? new Date(System.currentTimeMillis() + expires) : null, httpResponse);
                if (null == state) return;
                dispatcher.end(state);
                return;
            }
            this.sendResponse(requestData, result, httpRequest, httpResponse);
            if (null == state) return;
        }
        catch (OXException e) {
            block13: {
                if (!AjaxExceptionCodes.BAD_REQUEST.equals(e)) break block13;
                httpResponse.sendError(400, e.getMessage());
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            LOG.error((Object)e.getMessage(), (Throwable)e);
            APIResponseRenderer.writeResponse(new Response().setException(e), action, httpRequest, httpResponse);
            return;
            catch (RuntimeException e2) {
                LOG.error((Object)e2.getMessage(), (Throwable)e2);
                OXException exception = AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                APIResponseRenderer.writeResponse(new Response().setException(exception), action, httpRequest, httpResponse);
                return;
            }
        }
        finally {
            if (null != state) {
                dispatcher.end(state);
            }
        }
        dispatcher.end(state);
        return;
    }

    private ServerSession fakeSession() {
        UserImpl user = new UserImpl();
        user.setAttributes(new HashMap<String, Set<String>>());
        return new ServerSessionAdapter(NO_SESSION, new ContextImpl(-1), user);
    }

    protected void sendResponse(AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        int highest = Integer.MIN_VALUE;
        ResponseRenderer candidate = null;
        for (ResponseRenderer renderer : RESPONSE_RENDERERS) {
            if (!renderer.handles(requestData, result) || highest > renderer.getRanking()) continue;
            highest = renderer.getRanking();
            candidate = renderer;
        }
        if (null == candidate) {
            throw new IllegalStateException("No appropriate " + ResponseRenderer.class.getSimpleName() + " for request data/result pair.");
        }
        candidate.write(requestData, result, httpRequest, httpResponse);
    }
}

