/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestHandler;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceWriter;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerRequestHandlerRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class ResourceRequest {
    private static final Log LOG = LogFactory.getLog(ResourceRequest.class);
    private final ServerSession session;
    private Date timestamp;
    private static final String MODULE_RESOURCE = "resource";
    private static final String STR_ALL = "*";

    public ResourceRequest(ServerSession session) {
        this.session = session;
    }

    public Object action(String action, JSONObject jsonObject) throws OXException, JSONException {
        if (action.equalsIgnoreCase("list")) {
            return this.actionList(jsonObject);
        }
        if (action.equalsIgnoreCase("get")) {
            return this.actionGet(jsonObject);
        }
        if (action.equalsIgnoreCase("search")) {
            return this.actionSearch(jsonObject);
        }
        if (action.equalsIgnoreCase("all")) {
            return this.actionAll();
        }
        if (action.equalsIgnoreCase("updates")) {
            return this.actionUpdates(jsonObject);
        }
        AJAXRequestHandler handler = ServerRequestHandlerRegistry.getInstance().getHandler(MODULE_RESOURCE, action);
        if (null == handler) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
        }
        AJAXRequestResult result = handler.performAction(action, jsonObject, this.session, this.session.getContext());
        this.timestamp = result.getTimestamp();
        return result.getResultObject();
    }

    private JSONValue actionUpdates(JSONObject jsonObj) throws OXException, JSONException {
        Date lastModified = DataParser.checkDate(jsonObj, "timestamp");
        Resource[] updatedResources = null;
        Resource[] deletedResources = null;
        try {
            ResourceServiceImpl resService = ResourceServiceImpl.getInstance();
            updatedResources = resService.listModified(lastModified, this.session.getContext());
            deletedResources = resService.listDeleted(lastModified, this.session.getContext());
        }
        catch (OXException exc) {
            LOG.debug((Object)("Tried to find resources that were modified since " + lastModified), (Throwable)exc);
        }
        JSONArray modified = new JSONArray();
        long lm = 0L;
        if (updatedResources != null) {
            for (Resource res : updatedResources) {
                if (res.getLastModified().getTime() > lm) {
                    lm = res.getLastModified().getTime();
                }
                modified.put((Object)ResourceWriter.writeResource(res));
            }
        }
        JSONArray deleted = new JSONArray();
        if (deletedResources != null) {
            for (Resource res : deletedResources) {
                if (res.getLastModified().getTime() > lm) {
                    lm = res.getLastModified().getTime();
                }
                deleted.put((Object)ResourceWriter.writeResource(res));
            }
        }
        this.timestamp = new Date(lm);
        JSONObject retVal = new JSONObject();
        retVal.put("modified", (Object)modified);
        retVal.put("new", (Object)modified);
        retVal.put("deleted", (Object)deleted);
        return retVal;
    }

    private JSONArray actionList(JSONObject jsonObj) throws OXException, JSONException {
        JSONArray jsonResponseArray = new JSONArray();
        UserStorage userStorage = null;
        JSONArray jsonArray = DataParser.checkJSONArray(jsonObj, "data");
        int len = jsonArray.length();
        if (len > 0) {
            long lastModified = Long.MIN_VALUE;
            for (int a = 0; a < len; ++a) {
                JSONObject jData = jsonArray.getJSONObject(a);
                int id = DataParser.checkInt(jData, "id");
                Resource r = null;
                try {
                    r = ResourceServiceImpl.getInstance().getResource(id, this.session.getContext());
                }
                catch (OXException exc) {
                    LOG.debug((Object)"resource not found try to find id in user table", (Throwable)exc);
                }
                if (r == null) {
                    if (userStorage == null) {
                        userStorage = UserStorage.getInstance();
                    }
                    User u = userStorage.getUser(id, this.session.getContext());
                    r = new Resource();
                    r.setIdentifier(u.getId());
                    r.setDisplayName(u.getDisplayName());
                    r.setLastModified(new Date(0L));
                }
                if (lastModified < r.getLastModified().getTime()) {
                    lastModified = r.getLastModified().getTime();
                }
                jsonResponseArray.put((Object)ResourceWriter.writeResource(r));
            }
            this.timestamp = new Date(lastModified);
        } else {
            this.timestamp = new Date(0L);
        }
        return jsonResponseArray;
    }

    private JSONObject actionGet(JSONObject jsonObj) throws OXException, JSONException {
        int id = DataParser.checkInt(jsonObj, "id");
        Resource r = null;
        try {
            r = ResourceServiceImpl.getInstance().getResource(id, this.session.getContext());
        }
        catch (OXException exc) {
            LOG.debug((Object)"resource not found try to find id in user table", (Throwable)exc);
        }
        if (r == null) {
            User u = UserStorage.getInstance().getUser(id, this.session.getContext());
            r = new Resource();
            r.setIdentifier(u.getId());
            r.setDisplayName(u.getDisplayName());
            r.setLastModified(new Date(0L));
        }
        this.timestamp = r.getLastModified();
        return ResourceWriter.writeResource(r);
    }

    private JSONArray actionSearch(JSONObject jsonObj) throws OXException, JSONException {
        ResourceServiceImpl resourceService = ResourceServiceImpl.getInstance();
        if (null == resourceService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ResourceService.class.getName()});
        }
        JSONArray jsonResponseArray = new JSONArray();
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        if (!jData.has("pattern") || jData.isNull("pattern")) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringBuilder(64).append("Missing field \"").append("pattern").append("\" in JSON data. Searching for all as fallback"));
            }
            return this.actionAll();
        }
        String searchpattern = jData.getString("pattern");
        Resource[] resources = resourceService.searchResources(searchpattern, this.session.getContext());
        if (resources.length > 0) {
            long lastModified = Long.MIN_VALUE;
            for (Resource resource : resources) {
                if (lastModified < resource.getLastModified().getTime()) {
                    lastModified = resource.getLastModified().getTime();
                }
                jsonResponseArray.put((Object)ResourceWriter.writeResource(resource));
            }
            this.timestamp = new Date(lastModified);
        } else {
            this.timestamp = new Date(0L);
        }
        return jsonResponseArray;
    }

    private JSONArray actionAll() throws OXException {
        JSONArray jsonResponseArray = new JSONArray();
        Resource[] resources = ResourceServiceImpl.getInstance().searchResources(STR_ALL, this.session.getContext());
        if (resources.length > 0) {
            long lastModified = Long.MIN_VALUE;
            for (Resource resource : resources) {
                if (lastModified < resource.getLastModified().getTime()) {
                    lastModified = resource.getLastModified().getTime();
                }
                jsonResponseArray.put(resource.getIdentifier());
            }
            this.timestamp = new Date(lastModified);
        } else {
            this.timestamp = new Date(0L);
        }
        return jsonResponseArray;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

