/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.FinalContactConstants;
import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.parser.SearchTermParser;
import com.openexchange.ajax.writer.ContactWriter;
import com.openexchange.api2.FinalContactInterface;
import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactSearchMultiplexer;
import com.openexchange.groupware.contact.ContactUnificationState;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.links.Links;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.search.SearchTerm;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class ContactRequest {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactRequest.class));
    public static final String ACTION_GET_USER = "getuser";
    public static final String ACTION_LIST_USER = "listuser";
    private final ServerSession session;
    private final TimeZone timeZone;
    private Date timestamp;

    public Date getTimestamp() {
        return this.timestamp == null ? null : new Date(this.timestamp.getTime());
    }

    public ContactRequest(ServerSession session) {
        this.session = session;
        String sTimeZone = session.getUser().getTimeZone();
        this.timeZone = TimeZoneUtils.getTimeZone(sTimeZone);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("use timezone string: " + sTimeZone));
            LOG.debug((Object)("use user timezone: " + this.timeZone));
        }
    }

    public JSONValue action(String action, JSONObject jsonObject) throws JSONException, OXException {
        if (!this.session.getUserConfiguration().hasContact()) {
            throw OXException.noPermissionForModule((String)"contact");
        }
        if (action.equalsIgnoreCase("new")) {
            return this.actionNew(jsonObject);
        }
        if (action.equalsIgnoreCase("delete")) {
            return this.actionDelete(jsonObject);
        }
        if (action.equalsIgnoreCase("update")) {
            return this.actionUpdate(jsonObject);
        }
        if (action.equalsIgnoreCase("updates")) {
            return this.actionUpdates(jsonObject);
        }
        if (action.equalsIgnoreCase("list")) {
            return this.actionList(jsonObject);
        }
        if (action.equalsIgnoreCase(ACTION_LIST_USER)) {
            return this.actionListUser(jsonObject);
        }
        if (action.equalsIgnoreCase("all")) {
            return this.actionAll(jsonObject);
        }
        if (action.equalsIgnoreCase("get")) {
            return this.actionGet(jsonObject);
        }
        if (action.equalsIgnoreCase(ACTION_GET_USER)) {
            return this.actionGetUser(jsonObject);
        }
        if (action.equalsIgnoreCase("search")) {
            return this.actionSearch(jsonObject);
        }
        if (action.equalsIgnoreCase("advancedSearch")) {
            return this.actionTermSearch(jsonObject);
        }
        if (action.equalsIgnoreCase("copy")) {
            return this.actionCopy(jsonObject);
        }
        if (action.equalsIgnoreCase(FinalContactConstants.ACTION_ASSOCIATE.getName())) {
            return this.actionAssociate(jsonObject);
        }
        if (action.equalsIgnoreCase(FinalContactConstants.ACTION_DISSOCIATE.getName())) {
            return this.actionDissociate(jsonObject);
        }
        if (action.equalsIgnoreCase(FinalContactConstants.ACTION_GET_ASSOCIATED.getName())) {
            return this.actionGetAssociated(jsonObject);
        }
        if (action.equalsIgnoreCase(FinalContactConstants.ACTION_GET_ASSOCIATION.getName())) {
            return this.actionGetAssociation(jsonObject);
        }
        if (action.equalsIgnoreCase(FinalContactConstants.ACTION_GET_BY_UUID.getName())) {
            return this.actionGetByUuid(jsonObject);
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    public JSONValue actionGetByUuid(JSONObject jsonObj) throws JSONException, OXException {
        FinalContactInterface contactInterface = this.getFinalContactInterface();
        Contact contactObj = this.getFinalContact(contactInterface, jsonObj);
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone tz = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        ContactWriter contactwriter = new ContactWriter(tz);
        JSONObject jsonResponseObject = new JSONObject();
        contactwriter.writeContact(contactObj, jsonResponseObject, this.session);
        this.timestamp = contactObj.getLastModified();
        return jsonResponseObject;
    }

    public JSONValue actionGetAssociation(JSONObject jsonObject) throws JSONException, OXException {
        FinalContactInterface contactInterface = this.getFinalContactInterface();
        Contact[] twoContacts = this.getTwoFinalContacts(contactInterface, jsonObject);
        ContactUnificationState association = contactInterface.getAssociationBetween(twoContacts[0], twoContacts[1]);
        JSONObject ret = new JSONObject().put("state", association.getNumber());
        return ret;
    }

    private JSONValue actionGetAssociated(JSONObject jsonObject) throws JSONException, OXException {
        FinalContactInterface contactInterface = this.getFinalContactInterface();
        Contact contact = this.getFinalContact(contactInterface, jsonObject);
        String timeZoneId = DataParser.parseString(jsonObject, "timezone");
        TimeZone tz = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        List<UUID> associatedContacts = contactInterface.getAssociatedContacts(contact);
        JSONArray ret = new JSONArray();
        for (UUID associate : associatedContacts) {
            ret.put((Object)associate.toString());
        }
        return ret;
    }

    private JSONValue actionDissociate(JSONObject jsonObject) throws OXException {
        FinalContactInterface contactInterface = this.getFinalContactInterface();
        Contact[] twoContacts = this.getTwoFinalContacts(contactInterface, jsonObject);
        contactInterface.separateTwoContacts(twoContacts[0], twoContacts[1]);
        return null;
    }

    private JSONValue actionAssociate(JSONObject jsonObject) throws OXException {
        FinalContactInterface contactInterface = this.getFinalContactInterface();
        Contact[] twoContacts = this.getTwoFinalContacts(contactInterface, jsonObject);
        contactInterface.associateTwoContacts(twoContacts[0], twoContacts[1]);
        return null;
    }

    public JSONObject actionNew(JSONObject jsonObj) throws JSONException, OXException {
        Contact contactObj = new Contact();
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        ContactParser contactparser = new ContactParser();
        contactparser.parse(contactObj, jData);
        if (!contactObj.containsParentFolderID()) {
            throw OXException.mandatoryField((String)"missing folder");
        }
        ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(contactObj.getParentFolderID(), this.session);
        contactInterface.insertContactObject(contactObj);
        this.timestamp = contactObj.getLastModified();
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put("id", contactObj.getObjectID());
        return jsonResponseObject;
    }

    public JSONObject actionUpdate(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        Contact contactobject = new Contact();
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        ContactParser contactparser = new ContactParser();
        contactparser.parse(contactobject, jData);
        contactobject.setObjectID(id);
        ContactInterfaceDiscoveryService discoveryService = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class);
        ContactInterface contactIface = discoveryService.newContactInterface(inFolder, this.session);
        if (contactobject.containsParentFolderID() && contactobject.getParentFolderID() > 0) {
            int folderId = contactobject.getParentFolderID();
            ContactInterface targetContactIface = discoveryService.newContactInterface(folderId, this.session);
            if (!contactIface.getClass().equals(targetContactIface.getClass())) {
                Contact toMove = ContactRequest.move2AnotherProvider(id, inFolder, contactobject, contactIface, folderId, targetContactIface, this.session, this.timestamp);
                this.timestamp = toMove.getLastModified();
                return new JSONObject();
            }
        }
        contactIface.updateContactObject(contactobject, inFolder, this.timestamp);
        this.timestamp = contactobject.getLastModified();
        return new JSONObject();
    }

    public static Contact move2AnotherProvider(int id, int inFolder, Contact contact, ContactInterface contactIface, int newFolderId, ContactInterface targetContactIface, ServerSession session, Date timestamp) throws OXException {
        Contact toMove = contactIface.getObjectById(id, inFolder);
        for (int i = 1; i < Contacts.mapping.length; ++i) {
            if (null == Contacts.mapping[i] || !contact.contains(i)) continue;
            toMove.set(i, contact.get(i));
        }
        if (inFolder == 6) {
            toMove.removeInternalUserId();
        }
        toMove.setNumberOfAttachments(0);
        targetContactIface.insertContactObject(toMove);
        User user = session.getUser();
        UserConfiguration uc = session.getUserConfiguration();
        ContactRequest.copyAttachments(newFolderId, session, session.getContext(), toMove, id, inFolder, user, uc);
        ContactRequest.copyLinks(newFolderId, session, session.getContext(), toMove, id, inFolder, user);
        contactIface.deleteContactObject(id, inFolder, timestamp);
        return toMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionUpdates(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(" *, *");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = this.removeVirtual(columns);
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Date requestedTimestamp = DataParser.checkDate(jsonObj, "timestamp");
        this.timestamp = new Date(requestedTimestamp.getTime());
        int folderId = DataParser.checkInt(jsonObj, "folder");
        String ignore = DataParser.parseString(jsonObj, "ignore");
        if (ignore == null) {
            ignore = "deleted";
        }
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Contact> it = null;
        try {
            Contact contactObj;
            boolean bIgnoreDelete = false;
            if (ignore.indexOf("deleted") != -1) {
                bIgnoreDelete = true;
            }
            int[] internalColumns = ContactRequest.checkLastModified(columnsToLoad);
            ContactWriter contactWriter = new ContactWriter(timeZone);
            ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(folderId, this.session);
            it = contactInterface.getModifiedContactsInFolder(folderId, internalColumns, requestedTimestamp);
            while (it.hasNext()) {
                contactObj = (Contact)it.next();
                JSONArray jsonContactArray = new JSONArray();
                contactWriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                jsonResponseArray.put((Object)jsonContactArray);
                Date clm = contactObj.getLastModified();
                if (null == clm || !this.timestamp.before(clm)) continue;
                this.timestamp = clm;
            }
            if (!bIgnoreDelete) {
                it = contactInterface.getDeletedContactsInFolder(folderId, internalColumns, requestedTimestamp);
                while (it.hasNext()) {
                    contactObj = (Contact)it.next();
                    jsonResponseArray.put(contactObj.getObjectID());
                    Date clm = contactObj.getLastModified();
                    if (null == clm || !this.timestamp.before(clm)) continue;
                    this.timestamp = clm;
                }
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionDelete(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        int objectId = DataParser.checkInt(jData, "id");
        int inFolder = DataParser.checkInt(jData, "folder");
        ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(inFolder, this.session);
        contactInterface.deleteContactObject(objectId, inFolder, this.timestamp);
        return new JSONArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionList(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        Date lastModified = null;
        SearchIterator<Contact> it = null;
        JSONArray jsonResponseArray = new JSONArray();
        boolean isOneFolder = true;
        try {
            String[] sColumns = DataParser.checkString(jsonObj, "columns").split(" *, *");
            int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
            int[] columnsToLoad = this.removeVirtual(columns);
            JSONArray jData = DataParser.checkJSONArray(jsonObj, "data");
            int oldfolderId = 0;
            int[][] objectIdAndFolderId = new int[jData.length()][2];
            for (int a = 0; a < objectIdAndFolderId.length; ++a) {
                JSONObject jObject = jData.getJSONObject(a);
                objectIdAndFolderId[a][0] = DataParser.checkInt(jObject, "id");
                objectIdAndFolderId[a][1] = DataParser.checkInt(jObject, "folder");
                if (a > 0 && oldfolderId != objectIdAndFolderId[a][1]) {
                    isOneFolder = false;
                }
                oldfolderId = objectIdAndFolderId[0][1];
            }
            String timeZoneId = DataParser.parseString(jsonObj, "timezone");
            TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
            int[] internalColumns = ContactRequest.checkLastModified(columnsToLoad);
            try {
                if (isOneFolder) {
                    ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(oldfolderId, this.session);
                    ContactWriter contactwriter = new ContactWriter(timeZone);
                    it = contactInterface.getObjectsById(objectIdAndFolderId, internalColumns);
                    while (it.hasNext()) {
                        Contact contactObj = (Contact)it.next();
                        JSONArray jsonContactArray = new JSONArray();
                        contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                        jsonResponseArray.put((Object)jsonContactArray);
                        Date clm = contactObj.getLastModified();
                        if (clm == null || !this.timestamp.before(clm)) continue;
                        this.timestamp = clm;
                    }
                } else {
                    for (int a = 0; a < objectIdAndFolderId.length; ++a) {
                        ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(objectIdAndFolderId[a][1], this.session);
                        ContactWriter contactwriter = new ContactWriter(timeZone);
                        int[][] newObjectIdAndFolderId = new int[][]{{objectIdAndFolderId[a][0], objectIdAndFolderId[a][1]}};
                        it = contactInterface.getObjectsById(newObjectIdAndFolderId, internalColumns);
                        while (it.hasNext()) {
                            Contact contactObj = (Contact)it.next();
                            JSONArray jsonContactArray = new JSONArray();
                            contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                            jsonResponseArray.put((Object)jsonContactArray);
                            lastModified = contactObj.getLastModified();
                        }
                        if (lastModified == null || this.timestamp.getTime() >= lastModified.getTime()) continue;
                        this.timestamp = lastModified;
                    }
                }
            }
            catch (OXException e) {
                throw e;
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionListUser(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        JSONArray jsonResponseArray = new JSONArray();
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(" *, *");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        JSONArray jData = DataParser.checkJSONArray(jsonObj, "data");
        int[] userIdArray = new int[jData.length()];
        for (int a = 0; a < userIdArray.length; ++a) {
            userIdArray[a] = jData.getInt(a);
        }
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Context ctx = this.session.getContext();
        try {
            RdbContactSQLImpl contactInterface = new RdbContactSQLImpl(this.session, ctx);
            ContactWriter contactwriter = new ContactWriter(timeZone);
            for (int a = 0; a < userIdArray.length; ++a) {
                Contact contactObj = contactInterface.getUserById(userIdArray[a]);
                JSONArray jsonContactArray = new JSONArray();
                contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                jsonResponseArray.put((Object)jsonContactArray);
                Date clm = contactObj.getLastModified();
                if (null == clm || !this.timestamp.before(clm)) continue;
                this.timestamp = clm;
            }
        }
        catch (JSONException e) {
            throw OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
        }
        return jsonResponseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionAll(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(",");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = this.removeVirtual(columns);
        int folderId = DataParser.checkInt(jsonObj, "folder");
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        Order order = OrderFields.parse(DataParser.parseString(jsonObj, "order"));
        String collation = DataParser.parseString(jsonObj, "collation");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        int leftHandLimit = DataParser.parseInt(jsonObj, "left_hand_limit");
        int rightHandLimit = DataParser.parseInt(jsonObj, "right_hand_limit");
        this.timestamp = new Date(0L);
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Contact> it = null;
        try {
            int[] internalColumns = ContactRequest.checkLastModified(columnsToLoad);
            ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(folderId, this.session);
            ContactWriter contactwriter = new ContactWriter(timeZone);
            it = contactInterface.getContactsInFolder(folderId, leftHandLimit, rightHandLimit, orderBy, order, collation, internalColumns);
            while (it.hasNext()) {
                Contact contactObj = (Contact)it.next();
                JSONArray jsonContactArray = new JSONArray();
                contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                jsonResponseArray.put((Object)jsonContactArray);
                Date clm = contactObj.getLastModified();
                if (null == clm || !this.timestamp.before(clm)) continue;
                this.timestamp = clm;
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    private int[] removeVirtual(int[] columns) {
        TIntArrayList helper = new TIntArrayList(columns.length);
        for (int col : columns) {
            if (col == 6) continue;
            if (col == 606) {
                helper.add(570);
                continue;
            }
            helper.add(col);
        }
        return helper.toArray();
    }

    public JSONObject actionGet(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(inFolder, this.session);
        this.timestamp = new Date(0L);
        Contact contactObj = contactInterface.getObjectById(id, inFolder);
        ContactWriter contactwriter = new ContactWriter(timeZone);
        JSONObject jsonResponseObject = new JSONObject();
        contactwriter.writeContact(contactObj, jsonResponseObject, this.session);
        this.timestamp = contactObj.getLastModified();
        return jsonResponseObject;
    }

    public JSONObject actionGetUser(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Context ctx = this.session.getContext();
        RdbContactSQLImpl contactInterface = new RdbContactSQLImpl(this.session, ctx);
        this.timestamp = new Date(0L);
        Contact contactObj = contactInterface.getUserById(id);
        ContactWriter contactwriter = new ContactWriter(timeZone);
        JSONObject jsonResponseObject = new JSONObject();
        contactwriter.writeContact(contactObj, jsonResponseObject, this.session);
        this.timestamp = contactObj.getLastModified();
        return jsonResponseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionTermSearch(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(" *, *");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = this.removeVirtual(columns);
        int[] internalColumns = ContactRequest.checkLastModified(columnsToLoad);
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        Order order = OrderFields.parse(DataParser.parseString(jsonObj, "order"));
        String collation = DataParser.parseString(jsonObj, "collation");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        JSONArray filterContent = jData.getJSONArray("filter");
        SearchTerm<?> searchTerm = SearchTermParser.parse(filterContent);
        ContactSearchMultiplexer multiplexer = new ContactSearchMultiplexer(ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class));
        SearchIterator<Contact> it = multiplexer.extendedSearch(this.session, searchTerm, orderBy, order, collation, internalColumns);
        JSONArray jsonResponseArray = new JSONArray();
        try {
            ContactWriter contactwriter = new ContactWriter(timeZone);
            while (it.hasNext()) {
                Contact contactObj = (Contact)it.next();
                JSONArray jsonContactArray = new JSONArray();
                contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                jsonResponseArray.put((Object)jsonContactArray);
                Date clm = contactObj.getLastModified();
                if (null == clm || !this.timestamp.before(clm)) continue;
                this.timestamp = clm;
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        return jsonResponseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionSearch(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(" *, *");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = this.removeVirtual(columns);
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        this.timestamp = new Date(0L);
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        ContactSearchObject searchObj = new ContactSearchObject();
        if (jData.has("folder")) {
            if (jData.get("folder").getClass().equals(JSONArray.class)) {
                for (int folder : DataParser.parseJSONIntArray(jData, "folder")) {
                    searchObj.addFolder(folder);
                }
            } else {
                searchObj.addFolder(DataParser.parseInt(jData, "folder"));
            }
        }
        if (jData.has("pattern")) {
            searchObj.setPattern(DataParser.parseString(jData, "pattern"));
        }
        if (jData.has("startletter")) {
            searchObj.setStartLetter(DataParser.parseBoolean(jData, "startletter"));
        }
        if (jData.has("emailAutoComplete") && jData.getBoolean("emailAutoComplete")) {
            searchObj.setEmailAutoComplete(true);
        }
        if (jData.has("orSearch") && jData.getBoolean("orSearch")) {
            searchObj.setOrSearch(true);
        }
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        Order order = OrderFields.parse(DataParser.parseString(jsonObj, "order"));
        String collation = DataParser.parseString(jsonObj, "collation");
        searchObj.setSurname(DataParser.parseString(jData, "last_name"));
        searchObj.setDisplayName(DataParser.parseString(jData, "display_name"));
        searchObj.setGivenName(DataParser.parseString(jData, "first_name"));
        searchObj.setCompany(DataParser.parseString(jData, "company"));
        searchObj.setEmail1(DataParser.parseString(jData, "email1"));
        searchObj.setEmail2(DataParser.parseString(jData, "email2"));
        searchObj.setEmail3(DataParser.parseString(jData, "email3"));
        searchObj.setDepartment(DataParser.parseString(jData, "department"));
        searchObj.setStreetBusiness(DataParser.parseString(jData, "street_business"));
        searchObj.setCityBusiness(DataParser.parseString(jData, "city_business"));
        searchObj.setDynamicSearchField(DataParser.parseJSONIntArray(jData, "dynamicsearchfield"));
        searchObj.setDynamicSearchFieldValue(DataParser.parseJSONStringArray(jData, "dynamicsearchfieldvalue"));
        searchObj.setPrivatePostalCodeRange(DataParser.parseJSONStringArray(jData, "privatepostalcoderange"));
        searchObj.setBusinessPostalCodeRange(DataParser.parseJSONStringArray(jData, "businesspostalcoderange"));
        searchObj.setPrivatePostalCodeRange(DataParser.parseJSONStringArray(jData, "privatepostalcoderange"));
        searchObj.setOtherPostalCodeRange(DataParser.parseJSONStringArray(jData, "otherpostalcoderange"));
        searchObj.setBirthdayRange(DataParser.parseJSONDateArray(jData, "birthdayrange"));
        searchObj.setAnniversaryRange(DataParser.parseJSONDateArray(jData, "anniversaryrange"));
        searchObj.setNumberOfEmployeesRange(DataParser.parseJSONStringArray(jData, "numberofemployee"));
        searchObj.setSalesVolumeRange(DataParser.parseJSONStringArray(jData, "salesvolumerange"));
        searchObj.setCreationDateRange(DataParser.parseJSONDateArray(jData, "creationdaterange"));
        searchObj.setLastModifiedRange(DataParser.parseJSONDateArray(jData, "lastmodifiedrange"));
        searchObj.setCatgories(DataParser.parseString(jData, "categories"));
        searchObj.setSubfolderSearch(DataParser.parseBoolean(jData, "subfoldersearch"));
        searchObj.setYomiCompany(DataParser.parseString(jData, "yomiCompany"));
        searchObj.setYomiFirstname(DataParser.parseString(jData, "yomiFirstName"));
        searchObj.setYomiLastName(DataParser.parseString(jData, "yomiLastName"));
        int[] internalColumns = ContactRequest.checkLastModified(columnsToLoad);
        ContactSearchMultiplexer multiplexer = new ContactSearchMultiplexer(ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class));
        SearchIterator<Contact> it = multiplexer.extendedSearch(this.session, searchObj, orderBy, order, collation, internalColumns);
        JSONArray jsonResponseArray = new JSONArray();
        try {
            ContactWriter contactwriter = new ContactWriter(timeZone);
            while (it.hasNext()) {
                Contact contactObj = (Contact)it.next();
                JSONArray jsonContactArray = new JSONArray();
                contactwriter.writeArray(contactObj, columns, jsonContactArray, this.session);
                jsonResponseArray.put((Object)jsonContactArray);
                Date clm = contactObj.getLastModified();
                if (null == clm || !this.timestamp.before(clm)) continue;
                this.timestamp = clm;
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        return jsonResponseArray;
    }

    public JSONObject actionCopy(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        int folderId = DataParser.checkInt(jData, "folder_id");
        Context ctx = this.session.getContext();
        ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(folderId, this.session);
        Contact contactObj = contactInterface.getObjectById(id, inFolder);
        int origObjectId = contactObj.getObjectID();
        contactObj.removeObjectID();
        int origFolderId = contactObj.getParentFolderID();
        contactObj.setParentFolderID(folderId);
        if (inFolder == 6) {
            contactObj.removeInternalUserId();
        }
        contactObj.setNumberOfAttachments(0);
        contactInterface.insertContactObject(contactObj);
        User user = this.session.getUser();
        UserConfiguration uc = this.session.getUserConfiguration();
        ContactRequest.copyAttachments(folderId, this.session, ctx, contactObj, origObjectId, origFolderId, user, uc);
        ContactRequest.copyLinks(folderId, this.session, ctx, contactObj, origObjectId, origFolderId, user);
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put("id", contactObj.getObjectID());
        this.timestamp = contactObj.getLastModified();
        return jsonResponseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyLinks(int folderId, Session session, Context ctx, Contact contactObj, int origObjectId, int origFolderId, User user) throws OXException {
        LinkObject[] links2;
        Connection readCon = Database.get(ctx, false);
        try {
            links2 = Links.getAllLinksFromObject(origObjectId, 7, origFolderId, user.getId(), user.getGroups(), session, readCon);
        }
        finally {
            Database.back(ctx, false, readCon);
            readCon = null;
        }
        if (links2 == null || links2.length == 0) {
            return;
        }
        Connection writeCon = Database.get(ctx, true);
        try {
            for (LinkObject link : links2) {
                LinkObject copy;
                if (link.getFirstId() == origObjectId) {
                    copy = new LinkObject(contactObj.getObjectID(), 7, folderId, link.getSecondId(), link.getSecondType(), link.getSecondFolder(), ctx.getContextId());
                } else if (link.getSecondId() == origObjectId) {
                    copy = new LinkObject(link.getFirstId(), link.getFirstType(), link.getFirstFolder(), contactObj.getObjectID(), 7, folderId, ctx.getContextId());
                } else {
                    LOG.error((Object)"Invalid link retrieved from Links.getAllLinksFromObject(). Neither first nor second ID matches!");
                    continue;
                }
                Links.performLinkStorage(copy, user.getId(), user.getGroups(), session, writeCon);
            }
        }
        finally {
            Database.back(ctx, true, writeCon);
        }
    }

    private static void copyAttachments(int folderId, Session session, Context ctx, Contact contactObj, int origObjectId, int origFolderId, User user, UserConfiguration uc) throws OXException {
        AttachmentBase attachmentBase = Attachments.getInstance();
        SearchIterator iterator = attachmentBase.getAttachments(origFolderId, origObjectId, 7, ctx, user, uc).results();
        if (iterator.hasNext()) {
            try {
                attachmentBase.startTransaction();
                do {
                    AttachmentMetadata orig = (AttachmentMetadata)iterator.next();
                    AttachmentImpl copy = new AttachmentImpl(orig);
                    copy.setFolderId(folderId);
                    copy.setAttachedId(contactObj.getObjectID());
                    copy.setId(0);
                    attachmentBase.attachToObject(copy, attachmentBase.getAttachedFile(origFolderId, origObjectId, 7, orig.getId(), ctx, user, uc), session, ctx, user, uc);
                } while (iterator.hasNext());
                attachmentBase.commit();
            }
            catch (SearchIteratorException e) {
                try {
                    attachmentBase.rollback();
                }
                catch (OXException e1) {
                    LOG.error((Object)"Attachment transaction rollback failed", (Throwable)e1);
                }
                throw new OXException((OXException)((Object)e));
            }
            catch (OXException e) {
                try {
                    attachmentBase.rollback();
                }
                catch (OXException e1) {
                    LOG.error((Object)"Attachment transaction rollback failed", (Throwable)e1);
                }
                throw e;
            }
            finally {
                try {
                    iterator.close();
                }
                catch (SearchIteratorException e) {
                    LOG.error((Object)"SearchIterator could not be closed", (Throwable)e);
                }
                try {
                    attachmentBase.finish();
                }
                catch (OXException e) {
                    LOG.error((Object)"Attachment transaction finish failed", (Throwable)e);
                }
            }
        }
    }

    private static int[] checkLastModified(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != 5) continue;
            return columns;
        }
        int[] internalColumns = new int[columns.length + 1];
        System.arraycopy(columns, 0, internalColumns, 0, columns.length);
        internalColumns[columns.length] = 5;
        return internalColumns;
    }

    protected FinalContactInterface getFinalContactInterface() throws OXException, OXException {
        ContactInterface contactInterfaceTemp = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).newContactInterface(6, this.session);
        if (!(contactInterfaceTemp instanceof FinalContactInterface)) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(FinalContactConstants.ACTION_GET_BY_UUID.getName());
        }
        return (FinalContactInterface)contactInterfaceTemp;
    }

    protected Contact[] getTwoFinalContacts(FinalContactInterface contactInterface, JSONObject jsonObject) throws OXException, OXException, OXException {
        Contact c2;
        Contact c1;
        UUID uuid1 = DataParser.parseUUID(jsonObject, FinalContactConstants.PARAMETER_UUID1.getName());
        UUID uuid2 = DataParser.parseUUID(jsonObject, FinalContactConstants.PARAMETER_UUID2.getName());
        if (uuid1 == null) {
            int fid1 = DataParser.checkInt(jsonObject, FinalContactConstants.PARAMETER_FOLDER_ID1.getName());
            int id1 = DataParser.checkInt(jsonObject, FinalContactConstants.PARAMETER_CONTACT_ID1.getName());
            c1 = contactInterface.getObjectById(id1, fid1);
        } else {
            c1 = contactInterface.getContactByUUID(uuid1);
        }
        if (uuid2 == null) {
            int fid2 = DataParser.checkInt(jsonObject, FinalContactConstants.PARAMETER_FOLDER_ID2.getName());
            int id2 = DataParser.checkInt(jsonObject, FinalContactConstants.PARAMETER_CONTACT_ID2.getName());
            c2 = contactInterface.getObjectById(id2, fid2);
        } else {
            c2 = contactInterface.getContactByUUID(uuid2);
        }
        return new Contact[]{c1, c2};
    }

    protected Contact getFinalContact(FinalContactInterface contactInterface, JSONObject jsonObject) throws OXException, OXException, OXException {
        Contact c;
        UUID uuid = DataParser.parseUUID(jsonObject, FinalContactConstants.PARAMETER_UUID.getName());
        if (uuid == null) {
            int fid = DataParser.checkInt(jsonObject, "folder");
            int id = DataParser.checkInt(jsonObject, "id");
            c = contactInterface.getObjectById(id, fid);
        } else {
            c = contactInterface.getContactByUUID(uuid);
        }
        return c;
    }
}

