/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.CalendarParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class AppointmentParser
extends CalendarParser {
    protected AppointmentParser() {
    }

    public AppointmentParser(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public AppointmentParser(boolean parseAll, TimeZone timeZone) {
        this.parseAll = parseAll;
        this.timeZone = timeZone;
    }

    public void parse(Appointment appointmentobject, JSONObject jsonobject) throws OXException {
        try {
            this.parseElementAppointment(appointmentobject, jsonobject);
        }
        catch (OXException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
    }

    protected void parseElementAppointment(Appointment appointmentobject, JSONObject jsonobject) throws JSONException, OXException {
        boolean isFullTime = false;
        if (jsonobject.has("full_time")) {
            isFullTime = AppointmentParser.parseBoolean(jsonobject, "full_time");
            appointmentobject.setFullTime(isFullTime);
        }
        if (jsonobject.has("start_date")) {
            if (isFullTime) {
                appointmentobject.setStartDate(AppointmentParser.parseDate(jsonobject, "start_date"));
            } else {
                appointmentobject.setStartDate(AppointmentParser.parseTime(jsonobject, "start_date", this.timeZone));
            }
        }
        if (jsonobject.has("end_date")) {
            if (isFullTime) {
                appointmentobject.setEndDate(AppointmentParser.parseDate(jsonobject, "end_date"));
            } else {
                appointmentobject.setEndDate(AppointmentParser.parseTime(jsonobject, "end_date", this.timeZone));
            }
        }
        if (jsonobject.has("shown_as")) {
            appointmentobject.setShownAs(AppointmentParser.parseInt(jsonobject, "shown_as"));
        }
        if (jsonobject.has("location")) {
            appointmentobject.setLocation(AppointmentParser.parseString(jsonobject, "location"));
        }
        if (jsonobject.has("color_label")) {
            appointmentobject.setLabel(AppointmentParser.parseInt(jsonobject, "color_label"));
        }
        if (jsonobject.has("alarm")) {
            appointmentobject.setAlarm(AppointmentParser.parseInt(jsonobject, "alarm"));
        }
        if (jsonobject.has("ignore_conflicts")) {
            appointmentobject.setIgnoreConflicts(AppointmentParser.parseBoolean(jsonobject, "ignore_conflicts"));
        }
        if (jsonobject.has("timezone")) {
            appointmentobject.setTimezone(AppointmentParser.parseString(jsonobject, "timezone"));
        }
        if (jsonobject.has("recurrence_start")) {
            appointmentobject.setRecurringStart(AppointmentParser.parseDate(jsonobject, "recurrence_start").getTime());
        }
        this.parseElementCalendar(appointmentobject, jsonobject);
    }
}

