/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login.osgi;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.login.ConfigurationProperty;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LoginServletRegisterer
implements ServiceTrackerCustomizer<Object, Object> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(LoginServletRegisterer.class));
    private static final String SERVLET_PATH_APPENDIX = "login";
    private final BundleContext context;
    private final Lock lock = new ReentrantLock();
    private ConfigurationService configService;
    private HttpService httpService;
    private DispatcherPrefixService prefixService;
    private Login login;

    public LoginServletRegisterer(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        boolean needsRegistration;
        Object obj = this.context.getService(reference);
        this.lock.lock();
        try {
            if (obj instanceof ConfigurationService) {
                this.configService = (ConfigurationService)obj;
            }
            if (obj instanceof HttpService) {
                this.httpService = (HttpService)obj;
            }
            if (obj instanceof DispatcherPrefixService) {
                this.prefixService = (DispatcherPrefixService)obj;
            }
            boolean bl = needsRegistration = null != this.configService && null != this.httpService && this.login == null && this.prefixService != null;
            if (needsRegistration) {
                this.login = new Login();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (needsRegistration) {
            Hashtable<String, String> params = new Hashtable<String, String>(16);
            this.addProperty(params, ServerConfig.Property.UI_WEB_PATH);
            this.addProperty(params, ServerConfig.Property.COOKIE_HASH);
            this.addProperty(params, ServerConfig.Property.COOKIE_TTL);
            this.addProperty(params, ServerConfig.Property.COOKIE_FORCE_HTTPS);
            this.addProperty(params, ServerConfig.Property.FORCE_HTTPS);
            this.addProperty(params, ServerConfig.Property.IP_CHECK);
            this.addProperty(params, ServerConfig.Property.IP_MASK_V4);
            this.addProperty(params, ServerConfig.Property.IP_MASK_V6);
            String tmp = this.configService.getText("noipcheck.cnf");
            if (null != tmp) {
                ((Dictionary)params).put(ConfigurationProperty.NO_IP_CHECK_RANGE.getPropertyName(), tmp);
            }
            this.addProperty(params, ConfigurationProperty.SESSIOND_AUTOLOGIN);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_AUTOLOGIN);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_CLIENT);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_VERSION);
            this.addProperty(params, ConfigurationProperty.ERROR_PAGE_TEMPLATE);
            this.addProperty(params, ConfigurationProperty.INSECURE);
            this.addProperty(params, ConfigurationProperty.REDIRECT_IP_CHANGE_ALLOWED);
            try {
                LOG.info((Object)"Registering login servlet.");
                this.httpService.registerServlet(this.prefixService.getPrefix() + SERVLET_PATH_APPENDIX, (Servlet)new Login(), params, null);
            }
            catch (ServletException e) {
                LOG.error((Object)"Registering login servlet failed.", (Throwable)e);
            }
            catch (NamespaceException e) {
                LOG.error((Object)"Registering login servlet failed.", (Throwable)e);
            }
        }
        return obj;
    }

    private void addProperty(Dictionary<String, String> params, ServerConfig.Property property) {
        String propertyName = property.getPropertyName();
        params.put(propertyName, this.configService.getProperty(propertyName, property.getDefaultValue()));
    }

    private void addProperty(Dictionary<String, String> params, ConfigurationProperty property) {
        String propertyName = property.getPropertyName();
        String value = this.configService.getProperty(propertyName, property.getDefaultValue());
        if (null != value) {
            params.put(propertyName, value.trim());
        }
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        HttpService unregister = null;
        this.lock.lock();
        try {
            if (service instanceof ConfigurationService) {
                this.configService = null;
            }
            if (service instanceof HttpService) {
                if (this.login != null) {
                    unregister = this.httpService;
                    this.login = null;
                }
                this.httpService = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (null != unregister) {
            LOG.info((Object)"Unregistering login servlet.");
            unregister.unregister(DefaultDispatcherPrefixService.getInstance().getPrefix() + SERVLET_PATH_APPENDIX);
        }
        this.context.ungetService(reference);
    }
}

