/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.encoding.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HashCalculator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HashCalculator.class));
    private static final Pattern PATTERN_SPLIT = Pattern.compile("\\s*,\\s*");
    private static final Pattern PATTERN_NON_WORD_CHAR = Pattern.compile("\\W");

    public static String getHash(HttpServletRequest req, String client) {
        return HashCalculator.getHash(req, HashCalculator.getUserAgent(req), client);
    }

    public static String getHash(HttpServletRequest req, String userAgent, String client) {
        try {
            String[] fields;
            ConfigurationService service;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((null == userAgent ? HashCalculator.parseUserAgent(req, "") : userAgent).getBytes(Charsets.UTF_8));
            if (null != client) {
                md.update(client.getBytes(Charsets.UTF_8));
            }
            String fieldList = null == (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)) ? "" : service.getProperty("com.openexchange.cookie.hash.fields", "");
            for (String field : fields = PATTERN_SPLIT.split(fieldList, 0)) {
                String header = req.getHeader(field);
                if (header == null) continue;
                md.update(header.getBytes(Charsets.UTF_8));
            }
            return PATTERN_NON_WORD_CHAR.matcher(Base64.encode(md.digest())).replaceAll("");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.fatal((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getHash(HttpServletRequest req) {
        return HashCalculator.getHash(req, HashCalculator.getClient(req));
    }

    public static String getClient(HttpServletRequest req) {
        String parameter = req.getParameter("client");
        if (parameter == null) {
            return "default";
        }
        return parameter;
    }

    private static String parseUserAgent(HttpServletRequest req, String defaultValue) {
        String parameter = req.getParameter("clientUserAgent");
        return null == parameter ? defaultValue : parameter;
    }

    private static String getUserAgent(HttpServletRequest req) {
        String header = req.getHeader("user-agent");
        if (header == null) {
            return "";
        }
        return header;
    }
}

