/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.LinkRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.UnsynchronizedStringWriter;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Link
extends DataServlet {
    private static final transient Log LOG = LogFactory.getLog(Link.class);
    private static final long serialVersionUID = 8612709224269281439L;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Link.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
        try {
            JSONObject jsonObj;
            String action = Link.getAction(httpServletRequest);
            try {
                jsonObj = Link.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse);
                return;
            }
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            LinkRequest linkRequest = new LinkRequest(session, sw, ctx);
            linkRequest.action(action, jsonObj);
            response.setData(new JSONArray(sw.toString()));
        }
        catch (OXException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            response.setException(exc);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Response response;
        block8: {
            ServerSession session = Link.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            httpServletResponse.setContentType("text/javascript; charset=UTF-8");
            Tools.disableCaching(httpServletResponse);
            try {
                StringWriter sw = new StringWriter();
                String action = Link.getAction(httpServletRequest);
                String data = Link.getBody(httpServletRequest);
                if (data.length() > 0) {
                    JSONObject jsonObj;
                    Context ctx = ContextStorage.getStorageContext(session.getContextId());
                    LinkRequest linkRequest = new LinkRequest(session, sw, ctx);
                    JSONObject jsonDataObj = new JSONObject(data);
                    try {
                        jsonObj = Link.convertParameter2JSONObject(httpServletRequest);
                    }
                    catch (JSONException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                        this.writeResponse(response, httpServletResponse);
                        return;
                    }
                    jsonObj.put("data", (Object)jsonDataObj);
                    linkRequest.action(action, jsonObj);
                    try {
                        response.setData(new JSONArray(sw.toString()));
                    }
                    catch (JSONException e) {
                        response.setData(new JSONObject(sw.toString()));
                    }
                    break block8;
                }
                httpServletResponse.sendError(400, "no data found");
            }
            catch (OXException exc) {
                LOG.error((Object)exc.getMessage(), (Throwable)exc);
                response.setException(exc);
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error((Object)oje.getMessage(), (Throwable)oje);
                response.setException(oje);
            }
        }
        this.writeResponse(response, httpServletResponse);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserConfiguration().hasContact();
    }
}

