/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.GroupRequest;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Group
extends DataServlet {
    private static final long serialVersionUID = 6699123983027304951L;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Group.class));

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Group.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Group.parseMandatoryStringParameter(httpServletRequest, "action");
            try {
                jsonObj = Group.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse);
                return;
            }
            GroupRequest groupRequest = new GroupRequest(session);
            Object responseObj = groupRequest.action(action, jsonObj);
            response.setTimestamp(groupRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Group.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Group.parseMandatoryStringParameter(httpServletRequest, "action");
            String data = Group.getBody(httpServletRequest);
            try {
                jsonObj = Group.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse);
                return;
            }
            GroupRequest groupRequest = new GroupRequest(session);
            if (data.charAt(0) == '[') {
                JSONArray jData = new JSONArray(data);
                jsonObj.put("data", (Object)jData);
                Object responseObj = groupRequest.action(action, jsonObj);
                response.setTimestamp(groupRequest.getTimestamp());
                response.setData(responseObj);
            } else if (data.charAt(0) == '{') {
                JSONObject jData = new JSONObject(data);
                jsonObj.put("data", (Object)jData);
                Object responseObj = groupRequest.action(action, jsonObj);
                response.setTimestamp(groupRequest.getTimestamp());
                response.setData(responseObj);
            } else {
                httpServletResponse.sendError(400, "invalid json object");
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return true;
    }
}

