/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigMenu
extends SessionServlet {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ConfigMenu.class));
    private static final int BUFFER_SIZE = 512;
    private static final long serialVersionUID = -7113587607566553771L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = ConfigMenu.getServletSpecificURI(req);
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ServerSession sessionObj = ConfigMenu.getSessionObject((ServletRequest)req);
        SettingStorage stor = SettingStorage.getInstance(sessionObj);
        Response response = new Response(sessionObj);
        try {
            Setting setting = ConfigTree.getInstance().getSettingByPath(path);
            stor.readValues(setting);
            response.setData(ConfigMenu.convert2JS(setting));
        }
        catch (OXException e) {
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        try {
            ResponseWriter.write(response, resp.getWriter());
        }
        catch (JSONException e) {
            this.log("Error while writing response object.", e);
            ConfigMenu.sendError(resp);
        }
    }

    public static Object convert2JS(Setting setting) throws JSONException {
        Object retval = null;
        if (setting.isLeaf()) {
            Object[] multiValue = setting.getMultiValue();
            if (null == multiValue) {
                Object singleValue = setting.getSingleValue();
                if (null == singleValue) {
                    retval = JSONObject.NULL;
                } else if (singleValue instanceof JSONObject) {
                    retval = singleValue;
                } else {
                    try {
                        retval = new JSONObject(singleValue.toString());
                    }
                    catch (JSONException e) {
                        retval = singleValue;
                    }
                }
            } else {
                JSONArray array = new JSONArray();
                for (Object value : multiValue) {
                    array.put(value);
                }
                retval = array;
            }
        } else {
            JSONObject json = new JSONObject();
            for (Setting subSetting : setting.getElements()) {
                json.put(subSetting.getName(), ConfigMenu.convert2JS(subSetting));
            }
            retval = json;
        }
        return retval;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path;
        String value;
        ServerSession session = ConfigMenu.getSessionObject((ServletRequest)req);
        ServletInputStream input = req.getInputStream();
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(input.available());
        byte[] buf = new byte[512];
        int length = input.read(buf);
        while (length != -1) {
            baos.write(buf, 0, length);
            length = input.read(buf);
        }
        String encoding = req.getCharacterEncoding();
        if (null == encoding) {
            this.log("Client did not specify the character encoding.");
            encoding = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        if ((value = new String(baos.toByteArray(), Charsets.forName((String)encoding))).length() > 0 && value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if ((path = ConfigMenu.getServletSpecificURI(req)).length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        SettingStorage stor = SettingStorage.getInstance(session);
        Response response = new Response(session);
        try {
            Setting setting = ConfigTree.getInstance().getSettingByPath(path);
            setting.setSingleValue(value);
            this.saveSettingWithSubs(stor, setting);
        }
        catch (OXException e) {
            this.log(e.getMessage(), e);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        try {
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            if (response.hasError()) {
                ResponseWriter.write(response, resp.getWriter());
            }
        }
        catch (JSONException e) {
            this.log("Error while writing response object.", e);
            ConfigMenu.sendError(resp);
        }
    }

    private void saveSettingWithSubs(SettingStorage storage, Setting setting) throws OXException, JSONException {
        if (setting.isLeaf()) {
            String value = (String)setting.getSingleValue();
            if (null != value && value.length() > 0 && '[' == value.charAt(0)) {
                JSONArray array = new JSONArray(value);
                if (array.length() == 0) {
                    setting.setEmptyMultiValue();
                } else {
                    for (int i = 0; i < array.length(); ++i) {
                        setting.addMultiValue(array.getString(i));
                    }
                }
                setting.setSingleValue(null);
            }
            storage.save(setting);
        } else {
            JSONObject json = new JSONObject(setting.getSingleValue().toString());
            Iterator iter = json.keys();
            OXException exc = null;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Setting sub = ConfigTree.getSettingByPath(setting, new String[]{key});
                sub.setSingleValue(json.getString(key));
                try {
                    this.saveSettingWithSubs(storage, sub);
                }
                catch (OXException e) {
                    exc = e;
                }
            }
            if (null != exc) {
                throw exc;
            }
        }
    }
}

