/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum MessagingExceptionCodes implements OXExceptionCode
{
    UNEXPECTED_ERROR("An error occurred: %1$s", CATEGORY_ERROR, 1),
    SQL_ERROR("A SQL error occurred: %1$s", CATEGORY_ERROR, 2),
    IO_ERROR("An I/O error occurred: %1$s", CATEGORY_ERROR, 3),
    JSON_ERROR("A JSON error occurred: %1$s", CATEGORY_ERROR, 14),
    ACCOUNT_NOT_FOUND("Messaging account %1$s of service \"%2$s\" could not be found for user %3$s in context %4$s.", CATEGORY_ERROR, 4),
    OPERATION_NOT_SUPPORTED("The operation is not supported by service %1$s.", CATEGORY_ERROR, 6),
    FOLDER_NOT_FOUND("The folder \"%1$s\" cannot be found in account %2$s of service \"%3$s\" of user %4$s in context %5$s.", CATEGORY_ERROR, 7),
    INVALID_MESSAGE_IDENTIFIER("Invalid message identifier: %1$s", CATEGORY_ERROR, 8),
    INVALID_HEADER("Invalid header \"%1$s\": %2$s", CATEGORY_ERROR, 9),
    UNKNOWN_ACTION("Unknown action to perform: %1$s.", CATEGORY_ERROR, 10),
    MESSAGING_ERROR("A messaging error occurred: %1$s", CATEGORY_ERROR, 11),
    ADDRESS_ERROR("Wrongly formatted address: %1$s.", CATEGORY_ERROR, 12),
    UNKNOWN_MESSAGING_CONTENT("Unknown messaging content: %1$s.", CATEGORY_ERROR, 14),
    UNKNOWN_MESSAGING_SERVICE("Unknown messaging service: %1$s.", CATEGORY_SERVICE_DOWN, 15),
    MISSING_PARAMETER("Missing parameter: %1$s.", CATEGORY_USER_INPUT, 16),
    INVALID_PARAMETER("Invalid parameter: %1$s with value '%2$s'.", CATEGORY_USER_INPUT, 17),
    READ_ONLY("Messaging part is read-only.: %1$s", CATEGORY_USER_INPUT, 18),
    UNKNOWN_COLOR_LABEL("Unknown color label index: %1$s", CATEGORY_USER_INPUT, 19),
    DUPLICATE_FOLDER("A duplicate folder named \"%1$s\" already exists below parent folder \"%2$s\".", CATEGORY_ERROR, 20),
    NO_CREATE_ACCESS("No create access on mail folder %1$s.", CATEGORY_PERMISSION_DENIED, 21),
    NOT_CONNECTED("Not connected", CATEGORY_PERMISSION_DENIED, 22),
    INVALID_SORTING_COLUMN("Invalid sorting column. Cannot sort by %1$s.", CATEGORY_USER_INPUT, 23),
    ATTACHMENT_NOT_FOUND("No attachment found with section identifier %1$s in message %2$s in folder %3$s.", CATEGORY_ERROR, 24),
    MESSAGE_NOT_FOUND("Message %1$s not found in folder %2$s.", CATEGORY_ERROR, 25);

    private final Category category;
    private final int detailNumber;
    private final String message;

    private MessagingExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return "MESSAGING";
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

