/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingField;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.MessagingMessage;
import com.openexchange.messaging.MessagingMessageGetSwitch;
import com.openexchange.messaging.MessagingMessageSwitcher;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import javax.mail.internet.MailDateFormat;
import org.apache.commons.logging.Log;

public class MessagingComparator
implements Comparator<MessagingMessage> {
    private static final EnumSet<MessagingField> WHITELIST = EnumSet.of(MessagingField.ID, new MessagingField[]{MessagingField.FOLDER_ID, MessagingField.CONTENT_TYPE, MessagingField.FROM, MessagingField.TO, MessagingField.BCC, MessagingField.CC, MessagingField.SUBJECT, MessagingField.SIZE, MessagingField.SENT_DATE, MessagingField.RECEIVED_DATE, MessagingField.FLAGS, MessagingField.THREAD_LEVEL, MessagingField.DISPOSITION_NOTIFICATION_TO, MessagingField.PRIORITY, MessagingField.COLOR_LABEL});
    private final MessagingField field;
    private final MessagingMessageGetSwitch get;
    private final boolean descending;
    private final Locale locale;
    private final Collator collator;
    private static final String DATE = "Date";
    private static final SimpleDateFormat DATE_FORMAT = new MailDateFormat();
    private static final EnumSet<MessagingField> INT_FIELDS = EnumSet.of(MessagingField.PRIORITY, MessagingField.THREAD_LEVEL);

    public MessagingComparator(MessagingField field, Locale locale) throws OXException {
        this(field, false, locale);
    }

    public MessagingComparator(MessagingField field, boolean descending, Locale locale) throws OXException {
        this.checkField(field);
        this.field = field;
        this.descending = descending;
        this.locale = locale;
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
        this.get = new MessagingMessageGetSwitch();
    }

    private void checkField(MessagingField field) throws OXException {
        if (!WHITELIST.contains(field)) {
            throw MessagingExceptionCodes.INVALID_SORTING_COLUMN.create(new Object[]{field});
        }
    }

    @Override
    public int compare(MessagingMessage o1, MessagingMessage o2) {
        return this.descending ? -1 * this.compare0(o1, o2) : this.compare0(o1, o2);
    }

    private int compare0(MessagingMessage o1, MessagingMessage o2) {
        try {
            Object c1 = this.field.doSwitch((MessagingMessageSwitcher)this.get, new Object[]{o1});
            Object c2 = this.field.doSwitch((MessagingMessageSwitcher)this.get, new Object[]{o2});
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (null != this.field.getEquivalentHeader()) {
                Collection headers1 = (Collection)c1;
                Collection headers2 = (Collection)c2;
                MessagingHeader h1 = headers1.isEmpty() ? null : (MessagingHeader)headers1.iterator().next();
                MessagingHeader h2 = headers2.isEmpty() ? null : (MessagingHeader)headers2.iterator().next();
                c1 = this.getValue(h1);
                if (c1 == (c2 = this.getValue(h2))) {
                    return 0;
                }
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
            }
            c1 = this.transform(c1);
            c2 = this.transform(c2);
            if (String.class.isInstance(c1)) {
                String s1 = (String)c1;
                String s2 = (String)c2;
                return this.collator.compare(s1, s2);
            }
            if (Comparable.class.isInstance(c1)) {
                return ((Comparable)c1).compareTo(c2);
            }
            throw MessagingExceptionCodes.INVALID_SORTING_COLUMN.create(new Object[]{this.field});
        }
        catch (OXException x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue(MessagingHeader h) {
        if (DATE.equalsIgnoreCase(h.getName())) {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                try {
                    return DATE_FORMAT.parse(h.getValue());
                }
                catch (ParseException e) {
                    com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MessagingComparator.class)).error((Object)"Comparison failed.", (Throwable)e);
                }
            }
        }
        return h.getValue();
    }

    private Object transform(Object o) {
        if (INT_FIELDS.contains(this.field) && String.class.isInstance(o)) {
            try {
                return Integer.valueOf((String)o);
            }
            catch (NumberFormatException x) {
                return o;
            }
        }
        return o;
    }
}

