/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SearchIteratorDelegator<T>
implements SearchIterator<T> {
    private final Iterator<T> delegate;
    private final int size;
    private final List<OXException> warnings;

    public SearchIteratorDelegator(Iterator<T> iter) {
        this.delegate = iter;
        this.warnings = new ArrayList<OXException>(2);
        this.size = -1;
    }

    public SearchIteratorDelegator(Iterator<T> iter, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.delegate = iter;
        this.size = size;
        this.warnings = new ArrayList<OXException>(2);
    }

    public SearchIteratorDelegator(Collection<T> collection) {
        this(collection.iterator(), collection.size());
    }

    @Override
    public boolean hasNext() throws OXException {
        return this.delegate.hasNext();
    }

    @Override
    public T next() throws OXException {
        return this.delegate.next();
    }

    @Override
    public void close() throws OXException {
    }

    @Override
    public int size() {
        if (this.size < 0) {
            return -1;
        }
        return this.size;
    }

    public boolean hasSize() {
        return this.size >= 0;
    }

    @Override
    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    @Override
    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

