/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchIteratorAdapter<T>
implements SearchIterator<T> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(SearchIteratorAdapter.class));
    private static final SearchIterator EMPTY = new EmptySearchIterator();
    private final Iterator<T> delegate;
    private final int size;
    private final boolean b_size;
    private final List<OXException> warnings;

    public SearchIteratorAdapter(Iterator<T> iter) {
        this.delegate = iter;
        this.warnings = new ArrayList<OXException>(2);
        this.b_size = false;
        this.size = -1;
    }

    public SearchIteratorAdapter(Iterator<T> iter, int size) {
        this.delegate = iter;
        this.size = size;
        this.warnings = new ArrayList<OXException>(2);
        this.b_size = true;
    }

    @Override
    public boolean hasNext() throws OXException {
        return this.delegate.hasNext();
    }

    @Override
    public T next() throws OXException {
        return this.delegate.next();
    }

    @Override
    public void close() throws OXException {
    }

    @Override
    public int size() {
        if (!this.b_size) {
            return -1;
        }
        return this.size;
    }

    public boolean hasSize() {
        return this.b_size;
    }

    @Override
    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    @Override
    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public static <T> SearchIterator<T> emptyIterator() {
        return EMPTY;
    }

    public static <T> SearchIterator<T> createArrayIterator(T[] array) {
        if (null == array) {
            return SearchIteratorAdapter.emptyIterator();
        }
        return new ArrayIterator<T>(array);
    }

    public static <T> Iterable<T> toIterable(final SearchIterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                class SIIterator
                implements Iterator<T> {
                    final /* synthetic */ SearchIterator val$iterator;

                    SIIterator(SearchIterator searchIterator) {
                        this.val$iterator = searchIterator;
                    }

                    public boolean hasNext() {
                        try {
                            return this.val$iterator.hasNext();
                        }
                        catch (OXException e) {
                            SearchIteratorAdapter.access$000().error((Object)e.getMessage(), (Throwable)e);
                            return false;
                        }
                    }

                    public T next() {
                        try {
                            return this.val$iterator.next();
                        }
                        catch (OXException e) {
                            SearchIteratorAdapter.access$000().error((Object)e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new SIIterator(iterator);
            }
        };
    }

    public static <T> List<T> toList(SearchIterator<T> iterator) throws OXException {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    static /* synthetic */ org.apache.commons.logging.Log access$000() {
        return LOG;
    }

    private static final class EmptySearchIterator<T>
    implements SearchIterator<T> {
        protected EmptySearchIterator() {
        }

        @Override
        public boolean hasNext() throws OXException {
            return false;
        }

        @Override
        public T next() throws OXException {
            return null;
        }

        @Override
        public void close() throws OXException {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void addWarning(OXException warning) {
            throw new UnsupportedOperationException("Method is not implemented");
        }

        @Override
        public OXException[] getWarnings() {
            return null;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }
    }
}

