/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import java.util.Comparator;

public final class LogPropertyName
implements Comparable<LogPropertyName> {
    private final String propertyName;
    private final LogLevel logLevel;
    private final int hash;

    public LogPropertyName(String propertyName, LogLevel logLevel) {
        this.propertyName = propertyName;
        this.logLevel = null == logLevel ? LogLevel.ALL : logLevel;
        int prime = 31;
        int result = 1;
        this.hash = result = 31 * result + (propertyName == null ? 0 : propertyName.hashCode());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogPropertyName)) {
            return false;
        }
        LogPropertyName other = (LogPropertyName)obj;
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
    }

    public boolean isAll() {
        return LogLevel.ALL.equals((Object)this.logLevel);
    }

    public boolean isError() {
        return this.isAll() || LogLevel.ERROR.equals((Object)this.logLevel);
    }

    public boolean isWarning() {
        return this.isAll() || LogLevel.WARNING.equals((Object)this.logLevel);
    }

    public boolean isInfo() {
        return this.isAll() || LogLevel.INFO.equals((Object)this.logLevel);
    }

    public boolean isDebug() {
        return this.isAll() || LogLevel.DEBUG.equals((Object)this.logLevel);
    }

    public boolean implies(LogLevel logLevel) {
        return this.isAll() || this.logLevel.ordinal() <= logLevel.ordinal();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public int compareTo(LogPropertyName o) {
        return this.propertyName.compareToIgnoreCase(o.propertyName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append("LogPropertyName [");
        if (this.propertyName != null) {
            builder.append("propertyName=").append(this.propertyName).append(", ");
        }
        if (this.logLevel != null) {
            builder.append("logLevel=").append((Object)this.logLevel);
        }
        builder.append(']');
        return builder.toString();
    }

    public static enum LogLevel {
        ALL,
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL,
        OFF;


        public static LogLevel logLevelFor(String logLevel) {
            LogLevel[] values;
            if (null == logLevel) {
                return ALL;
            }
            for (LogLevel ll : values = LogLevel.values()) {
                if (!ll.name().equalsIgnoreCase(logLevel)) continue;
                return ll;
            }
            return ALL;
        }

        public boolean includes(LogLevel other) {
            if (this == OFF) {
                return false;
            }
            return other.ordinal() <= this.ordinal();
        }

        public static Comparator<LogLevel> getComparator() {
            return new Comparator<LogLevel>(){

                @Override
                public int compare(LogLevel o1, LogLevel o2) {
                    return o1.ordinal() - o2.ordinal();
                }
            };
        }
    }
}

