/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LocaleTools {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private static final String STR_EMPTY = "";
    private static final Pattern identifierPattern = Pattern.compile("(\\p{Lower}{2})(?:_(\\p{Upper}{2}))?(?:_([a-zA-Z]{2}))?");

    private LocaleTools() {
    }

    public static Locale getSaneLocale(Locale locale) {
        return locale == null ? DEFAULT_LOCALE : locale;
    }

    public static Locale getLocale(String fullIdentifier) {
        Matcher match = identifierPattern.matcher(fullIdentifier);
        Locale retval = null;
        if (match.matches()) {
            String country = match.group(2);
            String variant = match.group(3);
            retval = new Locale(match.group(1), country == null ? STR_EMPTY : country, variant == null ? STR_EMPTY : variant);
        }
        return retval;
    }

    public static String toLowerCase(String str) {
        char[] buf = new char[str.length()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toLowerCase(str.charAt(i));
        }
        return new String(buf);
    }
}

