/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.function.TObjectFunction;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ConcurrentTIntObjectHashMap<V>
extends TIntObjectHashMap<V>
implements Cloneable {
    private final TIntObjectHashMap<V> map;
    private ReadWriteLock readWriteLock;
    private final TIntObjectProcedure<V> PUT_ALL_PROC = new TIntObjectProcedure<V>(){

        public boolean execute(int key, V value) {
            ConcurrentTIntObjectHashMap.this.put(key, value);
            return true;
        }
    };

    public ConcurrentTIntObjectHashMap() {
        this.map = new TIntObjectHashMap();
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntObjectHashMap(int initialCapacity, float loadFactor) {
        this.map = new TIntObjectHashMap(initialCapacity, loadFactor);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntObjectHashMap(int initialCapacity) {
        this.map = new TIntObjectHashMap(initialCapacity);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntObjectHashMap<V> clone() {
        try {
            ConcurrentTIntObjectHashMap clone = (ConcurrentTIntObjectHashMap)super.clone();
            clone.readWriteLock = new ReentrantReadWriteLock();
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone not supported although Cloneable implemented.");
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySafeTo(TIntObjectMap<V> map) {
        if (null == map) {
            return;
        }
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            map.putAll(this.map);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIntObjectIterator<V> iterator() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            TIntObjectIterator tIntObjectIterator = this.map.iterator();
            return tIntObjectIterator;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int val) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.contains(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEach(TIntProcedure procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.forEach(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(int key, V value) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.map.put(key, value);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int desiredCapacity) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.ensureCapacity(desiredCapacity);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(int key, V value) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.map.putIfAbsent(key, value);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.compact();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(TIntObjectMap<? extends V> map) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            map.forEachEntry(this.PUT_ALL_PROC);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCompactionFactor(float factor) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.setAutoCompactionFactor(factor);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int key) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object object = this.map.get(key);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAutoCompactionFactor() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            float f = this.map.getAutoCompactionFactor();
            return f;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(int key) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            Object object = this.map.remove(key);
            return (V)object;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.equals(other);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.map.hashCode();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] values() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.map.values();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V[] values(V[] a) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.map.values((Object[])a);
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] keys() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int[] nArray = this.map.keys();
            return nArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] keys(int[] a) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int[] nArray = this.map.keys(a);
            return nArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object val) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.containsValue(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(int key) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachKey(TIntProcedure procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.forEachKey(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachValue(TObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.forEachValue(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachEntry(TIntObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.map.forEachEntry(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TIntObjectProcedure<? super V> procedure) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.map.retainEntries(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformValues(TObjectFunction<V, V> function) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.transformValues(function);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.map.writeExternal(out);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.map.readExternal(in);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            l.unlock();
        }
    }
}

