/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ConcurrentTIntHashSet
extends TIntHashSet
implements Cloneable {
    private final TIntHashSet set;
    private ReadWriteLock readWriteLock;

    public ConcurrentTIntHashSet() {
        this.set = new TIntHashSet();
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntHashSet(int initialCapacity, float loadFactor) {
        this.set = new TIntHashSet(initialCapacity, loadFactor);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntHashSet(int initialCapacity) {
        this.set = new TIntHashSet(initialCapacity);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntHashSet(int[] array) {
        this.set = new TIntHashSet(array);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ConcurrentTIntHashSet clone() {
        try {
            ConcurrentTIntHashSet clone = (ConcurrentTIntHashSet)super.clone();
            clone.readWriteLock = new ReentrantReadWriteLock();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone not supported although Cloneable implemented.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIntIterator iterator() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            TIntIterator tIntIterator = this.set.iterator();
            return tIntIterator;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.set.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int val) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.set.add(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int val) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.set.contains(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.set.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEach(TIntProcedure procedure) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.set.forEach(procedure);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int desiredCapacity) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.set.ensureCapacity(desiredCapacity);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.set.compact();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toArray() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int[] nArray = this.set.toArray();
            return nArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.set.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.set.equals(other);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCompactionFactor(float factor) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.set.setAutoCompactionFactor(factor);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            int n = this.set.hashCode();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAutoCompactionFactor() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            float f = this.set.getAutoCompactionFactor();
            return f;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int val) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.set.remove(val);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(int[] array) {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            boolean bl = this.set.containsAll(array);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int[] array) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.set.addAll(array);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(int[] array) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.set.removeAll(array);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            String string = this.set.toString();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(int[] array) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            boolean bl = this.set.retainAll(array);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.set.writeExternal(out);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.set.readExternal(in);
        }
        finally {
            l.unlock();
        }
    }
}

