/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.Reader;

public class UnsynchronizedStringReader
extends Reader {
    private final String str;
    private final int length;
    private int next = 0;
    private int mark = 0;

    public UnsynchronizedStringReader(String s) {
        this.str = s;
        this.length = s.length();
    }

    @Override
    public int read() throws IOException {
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next + n, cbuf, off);
        this.next += n;
        return n;
    }

    @Override
    public long skip(long ns) throws IOException {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.next;
    }

    @Override
    public void reset() throws IOException {
        this.next = this.mark;
    }

    @Override
    public void close() {
    }
}

