/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Java7ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final AtomicReferenceFieldUpdater<Java7ConcurrentLinkedQueue, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(Java7ConcurrentLinkedQueue.class, Node.class, "head");
    private static final AtomicReferenceFieldUpdater<Java7ConcurrentLinkedQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(Java7ConcurrentLinkedQueue.class, Node.class, "tail");

    public Java7ConcurrentLinkedQueue() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public Java7ConcurrentLinkedQueue(Collection<? extends E> c) {
        Node<Object> h = null;
        Node<Object> t = null;
        for (E e : c) {
            Java7ConcurrentLinkedQueue.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = new Node<Object>(null);
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> h, Node<E> p) {
        if (h != p && this.casHead(h, p)) {
            h.lazySetNext(h);
        }
    }

    final Node<E> succ(Node<E> p) {
        Node next = p.next;
        return p == next ? this.head : next;
    }

    @Override
    public boolean offer(E e) {
        Node t;
        Java7ConcurrentLinkedQueue.checkNotNull(e);
        Node<E> newNode = new Node<E>(e);
        Node p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!p.casNext(null, newNode)) continue;
                if (p != t) {
                    this.casTail(t, newNode);
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public E poll() {
        block0: while (true) {
            Node<Object> h;
            Node<Object> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null && p.casItem(item, null)) {
                    if (p != h) {
                        q = p.next;
                        this.updateHead(h, q != null ? q : p);
                    }
                    return item;
                }
                q = p.next;
                if (q == null) {
                    this.updateHead(h, p);
                    return null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return item;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    Node<E> first() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                boolean hasItem;
                boolean bl = hasItem = p.item != null;
                if (hasItem || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return hasItem ? p : null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int count = 0;
        Node<E> p = this.first();
        while (p != null && (p.item == null || ++count != Integer.MAX_VALUE)) {
            p = this.succ(p);
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item)) {
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> pred = null;
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                Node<E> next = this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                return true;
            }
            pred = p;
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node<E> beginningOfTheEnd = null;
        Node<E> last = null;
        for (E e : c) {
            Java7ConcurrentLinkedQueue.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            last.lazySetNext(newNode);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        Node p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!p.casNext(null, beginningOfTheEnd)) continue;
                if (!this.casTail(t, last)) {
                    t = this.tail;
                    if (last.next == null) {
                        this.casTail(t, last);
                    }
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public Object[] toArray() {
        ArrayList al = new ArrayList();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                al.add(item);
            }
            p = this.succ(p);
        }
        return al.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int k = 0;
        Node<E> p = this.first();
        while (p != null && k < a.length) {
            Object item = p.item;
            if (item != null) {
                a[k++] = item;
            }
            p = this.succ(p);
        }
        if (p == null) {
            if (k < a.length) {
                a[k] = null;
            }
            return a;
        }
        ArrayList al = new ArrayList();
        Node<E> q = this.first();
        while (q != null) {
            Object item = q.item;
            if (item != null) {
                al.add(item);
            }
            q = this.succ(q);
        }
        return al.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                s.writeObject(item);
            }
            p = this.succ(p);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = new Node<Object>(null);
        }
        this.head = h;
        this.tail = t;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return tailUpdater.compareAndSet(this, cmp, val);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node pred;
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            if (this.nextNode == null) {
                p = Java7ConcurrentLinkedQueue.this.first();
                pred = null;
            } else {
                pred = this.nextNode;
                p = Java7ConcurrentLinkedQueue.this.succ(this.nextNode);
            }
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.item;
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                Node next = Java7ConcurrentLinkedQueue.this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                p = next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        volatile E item;
        volatile Node<E> next;
        private static final AtomicReferenceFieldUpdater<Node, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");

        Node(E item) {
            itemUpdater.set(this, item);
        }

        boolean casItem(E cmp, E val) {
            return itemUpdater.compareAndSet(this, cmp, val);
        }

        void lazySetNext(Node<E> val) {
            nextUpdater.lazySet(this, val);
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }
    }
}

