/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.folder.actions.ListRequest;
import com.openexchange.webdav.xml.folder.actions.ListResponse;
import com.openexchange.webdav.xml.framework.WebDAVClient;
import java.io.IOException;
import java.util.Date;
import org.jdom2.JDOMException;

public final class FolderTools {
    private final WebDAVClient client;
    private FolderObject defaultAppointmentFolder;
    private FolderObject defaultContactFolder;

    public FolderTools(WebDAVClient client) {
        this.client = client;
    }

    public FolderObject getDefaultAppointmentFolder() throws IOException, JDOMException, OXException, OXException {
        return this.getDefaultAppointmentFolder(null);
    }

    public FolderObject getDefaultAppointmentFolder(String host) throws IOException, JDOMException, OXException, OXException {
        if (null == this.defaultAppointmentFolder) {
            ListRequest request = new ListRequest(new Date(0L));
            ListResponse response = this.client.execute(host, request);
            int userId = this.client.getGroupUserTools().getUserId(host);
            for (FolderObject folder : response) {
                if (!folder.isDefaultFolder() || folder.getModule() != 2 || folder.getCreatedBy() != userId) continue;
                this.defaultAppointmentFolder = folder;
                break;
            }
            if (null == this.defaultAppointmentFolder) {
                throw new TestException("Unable to find default appointment folder.");
            }
        }
        return this.defaultAppointmentFolder;
    }

    public FolderObject getDefaultContactFolder() throws OXException, IOException, JDOMException, OXException {
        return this.getDefaultContactFolder(null);
    }

    public FolderObject getDefaultContactFolder(String host) throws OXException, IOException, JDOMException, OXException {
        if (null == this.defaultContactFolder) {
            ListRequest request = new ListRequest(new Date(0L));
            ListResponse response = this.client.execute(host, request);
            int userId = this.client.getGroupUserTools().getUserId(host);
            for (FolderObject folder : response) {
                if (!folder.isDefaultFolder() || folder.getModule() != 3 || folder.getCreatedBy() != userId) continue;
                this.defaultContactFolder = folder;
                break;
            }
            if (null == this.defaultContactFolder) {
                throw new TestException("Unable to find default contact folder.");
            }
        }
        return this.defaultContactFolder;
    }
}

