/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.PutMethodWebRequest;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.AbstractWebdavTest;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.request.PropFindMethod;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractWebdavXMLTest
extends AbstractWebdavTest {
    protected static final int APPEND_MODIFIED = 1000000;

    public AbstractWebdavXMLTest(String name) {
        super(name);
    }

    protected static int parseResponse(Document response, boolean delete) throws Exception {
        return AbstractWebdavXMLTest.parseRootElement(response.getRootElement(), delete);
    }

    protected static int parseRootElement(Element e, boolean delete) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"root element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"root element", (String)"multistatus", (String)e.getName());
        return AbstractWebdavXMLTest.parseResponseElement(e.getChild("response", webdav), delete);
    }

    protected static int parseResponseElement(Element e, boolean delete) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"response element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"response element", (String)"response", (String)e.getName());
        AbstractWebdavXMLTest.parseHrefElement(e.getChild("href", webdav), delete);
        return AbstractWebdavXMLTest.parsePropstatElement(e.getChild("propstat", webdav));
    }

    protected static void parseHrefElement(Element e, boolean delete) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"response element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"response element", (String)"href", (String)e.getName());
        if (!delete) {
            AbstractWebdavXMLTest.assertTrue((String)"href value > 0", (Integer.parseInt(e.getValue()) > 0 ? 1 : 0) != 0);
        }
    }

    protected static int parsePropstatElement(Element e) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"propstat element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"propstat element", (String)"propstat", (String)e.getName());
        AbstractWebdavXMLTest.parseStatusElement(e.getChild("status", webdav));
        AbstractWebdavXMLTest.parseResponsedescriptionElement(e.getChild("responsedescription", webdav));
        return AbstractWebdavXMLTest.parsePropElement(e.getChild("prop", webdav));
    }

    protected static int parsePropElement(Element e) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"prop element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"prop element", (String)"prop", (String)e.getName());
        return AbstractWebdavXMLTest.parseObjectIdElement(e.getChild("object_id", XmlServlet.NS));
    }

    protected static void parseStatusElement(Element e) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"status element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"status element", (String)"status", (String)e.getName());
        AbstractWebdavXMLTest.assertNotNull((String)"status not null", (Object)e.getValue());
        AbstractWebdavXMLTest.assertEquals((String)"status 200", (int)200, (int)Integer.parseInt(e.getValue()));
    }

    protected static void parseResponsedescriptionElement(Element e) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"status element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"status element", (String)"responsedescription", (String)e.getName());
        AbstractWebdavXMLTest.assertNotNull((String)"response description not null", (Object)e.getValue());
    }

    protected static int parseObjectIdElement(Element e) throws Exception {
        AbstractWebdavXMLTest.assertNotNull((String)"object_id element (null)", (Object)e);
        AbstractWebdavXMLTest.assertEquals((String)"object_id element", (String)"object_id", (String)e.getName());
        AbstractWebdavXMLTest.assertNotNull((String)"object_id null", (Object)e.getValue());
        int objectId = Integer.parseInt(e.getValue());
        AbstractWebdavXMLTest.assertTrue((String)"object id > 0", (objectId > 0 ? 1 : 0) != 0);
        return objectId;
    }

    protected static Element addProp2PropertyUpdate(Element eProp) throws Exception {
        Element rootElement = new Element("propertyupdate", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        Element eSet = new Element("set", webdav);
        eSet.addContent((Content)eProp);
        rootElement.addContent((Content)eSet);
        return rootElement;
    }

    protected static Document addProp2Document(Element eProp) throws Exception {
        Element rootElement = new Element("propertyupdate", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        Element eSet = new Element("set", webdav);
        eSet.addContent((Content)eProp);
        rootElement.addContent((Content)eSet);
        return new Document(rootElement);
    }

    protected int sendPut(byte[] b) throws Exception {
        return this.sendPut(b, false);
    }

    protected int sendPut(byte[] b, boolean delete) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        this.req = new PutMethodWebRequest("http://" + this.hostName + this.getURL(), (InputStream)bais, "text/javascript");
        this.req.setHeaderField("Authorization", "Basic " + this.authData);
        this.resp = this.webCon.getResponse(this.req);
        bais = new ByteArrayInputStream(this.resp.getText().getBytes(Charsets.UTF_8));
        Document doc = new SAXBuilder().build((InputStream)bais);
        return AbstractWebdavXMLTest.parseResponse(doc, delete);
    }

    protected void sendPropFind(byte[] requestByte) throws Exception {
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(null, (Credentials)new UsernamePasswordCredentials(this.login, this.password));
        PropFindMethod propFindMethod = new PropFindMethod("http://" + this.hostName + this.getURL());
        propFindMethod.setDoAuthentication(true);
        InputStream is = new ByteArrayInputStream(requestByte);
        propFindMethod.setRequestBody(is);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        AbstractWebdavXMLTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        is = propFindMethod.getResponseBodyAsStream();
        Document doc = new SAXBuilder().build(is);
        AbstractWebdavXMLTest.parseResponse(doc, false);
    }

    protected void deleteObject(FolderChildObject folderChildObj, int inFolder) throws Exception {
        Element e_prop = new Element("prop", webdav);
        Element e_objectId = new Element("object_id", XmlServlet.NS);
        e_objectId.addContent(String.valueOf(folderChildObj.getObjectID()));
        e_prop.addContent((Content)e_objectId);
        if (inFolder != -1) {
            Element eFolderId = new Element("folder_id", XmlServlet.NS);
            eFolderId.addContent(String.valueOf(inFolder));
            e_prop.addContent((Content)eFolderId);
        }
        Element e_method = new Element("method", XmlServlet.NS);
        e_method.addContent("DELETE");
        e_prop.addContent((Content)e_method);
        byte[] b = null;
        this.sendPut(b, true);
    }

    protected void listObjects(int folderId, Date lastSync, boolean delete) throws Exception {
        Element e_propfind = new Element("propfind", webdav);
        Element e_prop = new Element("prop", webdav);
        Element e_folderId = new Element("folder_id", XmlServlet.NS);
        Element e_lastSync = new Element("lastsync", XmlServlet.NS);
        Element e_objectmode = new Element("objectmode", XmlServlet.NS);
        e_folderId.addContent(String.valueOf(folderId));
        e_lastSync.addContent(String.valueOf(lastSync.getTime()));
        e_propfind.addContent((Content)e_prop);
        e_prop.addContent((Content)e_folderId);
        e_prop.addContent((Content)e_lastSync);
        if (delete) {
            e_objectmode.addContent("NEW_AND_MODIFIED,DELETED");
            e_prop.addContent((Content)e_objectmode);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(e_propfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        this.sendPropFind(baos.toByteArray());
    }

    protected void loadObject(int objectId) throws Exception {
        Element e_propfind = new Element("propfind", webdav);
        Element e_prop = new Element("prop", webdav);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eObjectId.addContent(String.valueOf(objectId));
        e_propfind.addContent((Content)e_prop);
        e_prop.addContent((Content)eObjectId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(e_propfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        this.sendPropFind(baos.toByteArray());
    }

    protected String getURL() {
        return "no/url";
    }

    public static final String appendPrefix(String host) {
        if (host.startsWith("http://")) {
            return host;
        }
        return "http://" + host;
    }

    public static void assertEqualsAndNotNull(String message, Date expect, Date value) throws Exception {
        if (expect != null) {
            AbstractWebdavXMLTest.assertNotNull((String)(message + " is null"), (Object)value);
            AbstractWebdavXMLTest.assertEquals((String)message, (long)expect.getTime(), (long)value.getTime());
        }
    }

    public static void assertEqualsAndNotNull(String message, Date[] expect, Date[] value) throws Exception {
        if (expect != null) {
            AbstractWebdavXMLTest.assertNotNull((String)(message + " is null"), (Object)value);
            AbstractWebdavXMLTest.assertEquals((String)(message + " date array size is not equals"), (int)expect.length, (int)value.length);
            for (int a = 0; a < expect.length; ++a) {
                AbstractWebdavXMLTest.assertEquals((String)(message + " date in pos (" + a + ") is not equals"), (long)expect[a].getTime(), (long)value[a].getTime());
            }
        }
    }

    public static void assertEqualsAndNotNull(String message, byte[] expect, byte[] value) throws Exception {
        if (expect != null) {
            AbstractWebdavXMLTest.assertNotNull((String)(message + " is null"), (Object)value);
            AbstractWebdavXMLTest.assertEquals((String)(message + " byte array size is not equals"), (int)expect.length, (int)value.length);
            for (int a = 0; a < expect.length; ++a) {
                AbstractWebdavXMLTest.assertEquals((String)(message + " byte in pos (" + a + ") is not equals"), (byte)expect[a], (byte)value[a]);
            }
        }
    }

    public static void assertEqualsAndNotNull(String message, Object expect, Object value) throws Exception {
        if (expect != null) {
            AbstractWebdavXMLTest.assertNotNull((String)(message + " is null"), (Object)value);
            AbstractWebdavXMLTest.assertEquals((String)message, (Object)expect, (Object)value);
        }
    }

    @Deprecated
    protected static void assertExceptionMessage(String message, int expectedStatus) throws Exception {
        AbstractWebdavXMLTest.assertExceptionMessage(message, String.valueOf(expectedStatus));
    }

    protected static void assertExceptionMessage(String message, String expectedStatus) throws Exception {
        String statusCode = message.substring(1, message.indexOf("]"));
        AbstractWebdavXMLTest.assertEquals((String)"Status code is not correct", (String)expectedStatus, (String)statusCode);
    }
}

