/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.StructureTest;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavMoveAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.IOException;

public class MoveTest
extends StructureTest {
    @Override
    public void testResource() throws Exception {
        WebdavPath INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        WebdavPath MOVED_INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"moved_index.html"});
        this.doMove(INDEX_HTML_URL, MOVED_INDEX_HTML_URL);
        this.doMove(MOVED_INDEX_HTML_URL, INDEX_HTML_URL);
    }

    public void testRenameToLowerCase() throws IOException, OXException {
        WebdavPath INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        WebdavPath MOVED_INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"InDeX.html"});
        this.doMove(INDEX_HTML_URL, MOVED_INDEX_HTML_URL);
        this.doMove(MOVED_INDEX_HTML_URL, INDEX_HTML_URL);
    }

    private void doMove(WebdavPath INDEX_HTML_URL, WebdavPath MOVED_INDEX_HTML_URL) throws IOException, OXException {
        String content = this.getContent(INDEX_HTML_URL);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(INDEX_HTML_URL);
        req.setHeader("Destination", MOVED_INDEX_HTML_URL.toString());
        WebdavMoveAction action = new WebdavMoveAction(this.factory);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        MoveTest.assertEquals((int)201, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(INDEX_HTML_URL);
        MoveTest.assertFalse((boolean)resource.exists());
        resource = this.factory.resolveResource(MOVED_INDEX_HTML_URL);
        MoveTest.assertTrue((boolean)resource.exists());
        MoveTest.assertEquals((String)content, (String)this.getContent(MOVED_INDEX_HTML_URL));
    }

    @Override
    public WebdavAction getAction(WebdavFactory factory) {
        return new WebdavMoveAction(factory);
    }
}

