/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.meterware.httpunit.Base64;
import com.meterware.httpunit.WebRequest;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.test.WebdavInit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.WebdavResources;

public class WebdavClientTest
extends TestCase {
    protected Properties webdavProps;
    protected String login;
    protected String password;
    protected String hostname;
    protected List<String> clean = new ArrayList<String>();
    private String path;

    public void setUp() throws Exception {
        this.webdavProps = WebdavInit.getWebdavProperties();
        this.login = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"login", (String)"");
        this.password = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"password", (String)"");
        this.hostname = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"hostname", (String)"localhost");
        this.path = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"infostore_subpath", (String)"");
    }

    public void tearDown() throws Exception {
        for (String url : this.clean) {
            this.getResource(url).deleteMethod();
        }
    }

    protected WebdavResource getResource(String url, String login, String password) throws HttpException, IOException {
        HttpURL httpUrl = new HttpURL(this.getUrl(url));
        httpUrl.setUserinfo(login, password);
        WebdavResource res = new WebdavResource(httpUrl, 0, 1);
        return res;
    }

    protected String getUrl(String url) {
        return "http://" + this.hostname + "/servlet/webdav.infostore/" + this.path + "/" + url;
    }

    protected WebdavResource getResource(String url) throws HttpException, IOException {
        return this.getResource(url, this.login, this.password);
    }

    public void mkdir(String path) throws HttpException, IOException {
        this.getResource(path).mkcolMethod();
    }

    public void save(String path, String data) throws HttpException, IOException {
        this.getResource(path).putMethod(data);
    }

    public void cp(String from, String to) throws HttpException, IOException {
        this.getResource(from).copyMethod(this.getUrl(to));
    }

    public void mv(String from, String to) throws HttpException, IOException {
        this.getResource(from).moveMethod(this.getUrl(to));
    }

    public void lock(String resource) throws HttpException, IOException {
        this.getResource(resource).lockMethod();
    }

    public String lock(String resource, int seconds) throws HttpException, IOException {
        WebdavResource res = this.getResource(resource);
        boolean locked = res.lockMethod(((Object)((Object)this)).getClass().getName(), seconds);
        WebdavClientTest.assertTrue((String)"Lock failed", (boolean)locked);
        return res.getLockDiscovery().getActiveLocks()[0].getLockToken();
    }

    public void assertContent(String path, String ... names) throws HttpException, IOException {
        WebdavResource res = this.getResource(path);
        WebdavResources resources = res.getChildResources();
        HashSet<String> expected = new HashSet<String>(Arrays.asList(names));
        Enumeration enumeration = resources.getResourceNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            WebdavClientTest.assertTrue((String)(name + " not expected"), (boolean)expected.remove(name));
        }
        WebdavClientTest.assertTrue((String)((Object)expected).toString(), (boolean)expected.isEmpty());
    }

    public void assertBody(String path, InputStream body) throws HttpException, IOException {
        InputStream is = this.getResource(path).getMethodData();
        this.assertEqualContent(is, body);
    }

    public void assertEqualContent(InputStream is, InputStream body) throws IOException {
        int i = 0;
        int j = 0;
        while ((i = is.read()) != -1) {
            j = body.read();
            WebdavClientTest.assertEquals((int)j, (int)i);
        }
        WebdavClientTest.assertEquals((int)-1, (int)body.read());
    }

    public void assertBody(String path, String content) throws HttpException, IOException {
        WebdavClientTest.assertEquals((String)content, (String)this.getResource(path).getMethodDataAsString());
    }

    public void setAuth(WebRequest req) {
        if (this.password == null) {
            this.password = "";
        }
        String authData = new String(Base64.encode((String)(this.login + ":" + this.password)));
        req.setHeaderField("authorization", "Basic " + authData);
    }

    public void setAuth(HttpClient client) {
        if (this.password == null) {
            this.password = "";
        }
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.login, this.password));
    }
}

