/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.publish.Publication;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.util.HashMap;
import java.util.Map;

public class PublicationFixtureFactory
implements FixtureFactory<Publication> {
    private final FixtureLoader fixtureLoader;

    public PublicationFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Publication> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new PublicationFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class PublicationFixtures
    extends DefaultFixtures<Publication>
    implements Fixtures<Publication> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Publication>> publications;

        public PublicationFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader) {
            super(Publication.class, entries, fixtureLoader);
            this.publications = new HashMap<String, Fixture<Publication>>();
            this.entries = entries;
        }

        @Override
        public Fixture<Publication> getEntry(String entryName) throws OXException {
            if (this.publications.containsKey(entryName)) {
                return this.publications.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            this.defaults(values);
            Publication publication = new Publication();
            HashMap<String, String> config = new HashMap<String, String>();
            if (values.containsKey("target")) {
                config.put("target", values.get("target"));
                values.remove("target");
            }
            if (values.containsKey("site_name")) {
                config.put("site_name", values.get("site_name"));
                values.remove("site_name");
            }
            if (values.containsKey("secret")) {
                config.put("secret", values.get("secret"));
                values.remove("secret");
            }
            publication.setConfiguration(config);
            this.apply(publication, values);
            Fixture<Publication> fixture = new Fixture<Publication>(publication, values.keySet().toArray(new String[values.size()]), values);
            this.publications.put(entryName, fixture);
            return fixture;
        }

        private void defaults(Map<String, String> values) {
            if (!values.containsKey("displayName")) {
                values.put("displayName", values.get("site_name"));
            }
        }
    }
}

