/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.test.AjaxInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;

public final class ResourceDeleteTest
extends TestCase {
    private Context ctx;
    private User user;
    private User admin;
    private static final String SQL_SELECT_DELETE = "SELECT t.id, t.identifier FROM del_resource AS t WHERE t.cid = ? AND t.id = ?";
    private static final String SQL_DELETE_DELETE = "DELETE FROM del_resource WHERE cid = ? AND id = ?";
    private static final String SQL_DELETE = "DELETE FROM resource WHERE cid = ? AND id = ?";

    public ResourceDeleteTest() {
    }

    public ResourceDeleteTest(String name) {
        super(name);
    }

    private static Context resolveContext(String ctxStr) throws Exception {
        try {
            int pos = -1;
            pos = ctxStr.indexOf(64);
            String c = pos > -1 ? ctxStr.substring(pos + 1) : ctxStr;
            return ContextStorage.getStorageContext((int)ContextStorage.getInstance().getContextId(c));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static User resolveUser(String user, Context ctx) throws Exception {
        try {
            int pos = -1;
            pos = user.indexOf(64);
            String u = pos > -1 ? user.substring(0, pos) : user;
            return UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId(u, ctx), ctx);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    protected void setUp() throws Exception {
        try {
            Init.startServer();
            String login = AjaxInit.getAJAXProperty("login");
            this.ctx = ResourceDeleteTest.resolveContext(login);
            this.user = ResourceDeleteTest.resolveUser(login, this.ctx);
            this.admin = UserStorage.getInstance().getUser(this.ctx.getMailadmin(), this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceDelete() throws OXException, OXException, SQLException {
        int id = -1;
        try {
            Resource resource = ResourceDeleteTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            ResourceDeleteTest.assertTrue((String)("Invalid ID detected: " + id + ". ID has not been properly set through creation"), (id != -1 ? 1 : 0) != 0);
            ResourceDeleteTest.assertTrue((String)("Invalid last-modified detected: " + resource.getLastModified() + ". Last-modified timestamp has not been properly set through creation"), (resource.getLastModified() != null && resource.getLastModified().getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).delete(this.admin, this.ctx, resource, resource.getLastModified());
            OXException expected = null;
            try {
                ResourceStorage.getInstance().getResource(id, this.ctx);
            }
            catch (OXException e) {
                expected = e;
            }
            ResourceDeleteTest.assertTrue((String)"Resource has not been deleted", (expected != null ? 1 : 0) != 0);
            Connection con = Database.get((Context)this.ctx, (boolean)true);
            try {
                PreparedStatement stmt = con.prepareStatement(SQL_SELECT_DELETE);
                ResultSet rs = null;
                try {
                    stmt.setInt(1, this.ctx.getContextId());
                    stmt.setInt(2, id);
                    rs = stmt.executeQuery();
                    ResourceDeleteTest.assertTrue((String)"No entry found in backup table", (rs.next() && rs.getInt(1) == id ? 1 : 0) != 0);
                    ResourceDeleteTest.assertFalse((String)"Duplicate entry found in backup table", (boolean)rs.next());
                    rs.close();
                    rs = null;
                    stmt.close();
                    stmt = con.prepareStatement(SQL_DELETE_DELETE);
                    stmt.setInt(1, this.ctx.getContextId());
                    stmt.setInt(2, id);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ResourceDeleteTest.fail((String)e.getMessage());
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        rs = null;
                    }
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                Database.back((Context)this.ctx, (boolean)true, (Connection)con);
            }
            id = -1;
        }
        finally {
            ResourceDeleteTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail007() {
        int id = -1;
        try {
            Resource resource = ResourceDeleteTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            resource.setIdentifier(-1);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).delete(this.admin, this.ctx, resource, resource.getLastModified());
            ResourceDeleteTest.fail((String)"Delete succeeded with missing mandatory field");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceDeleteTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    private static final Resource createDummyResource(User admin, Context ctx) throws OXException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R");
        ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(admin, ctx, resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteResource(int id, int cid) {
        Connection writeCon;
        if (-1 == id) {
            return;
        }
        try {
            writeCon = Database.get((int)cid, (boolean)true);
        }
        catch (OXException e) {
            e.printStackTrace();
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DELETE);
            stmt.setInt(1, cid);
            stmt.setInt(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
                stmt = null;
            }
            Database.back((int)cid, (boolean)true, (Connection)writeCon);
        }
    }
}

