/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pubsub;

import com.openexchange.groupware.container.Contact;
import com.openexchange.pubsub.BasicContactTemplateTest;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.microformats.MicroformatSubscribeService;
import com.openexchange.templating.OXTemplate;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class BasicCensoredContactTemplateTest
extends BasicContactTemplateTest {
    public static final int[] CENSORED_COLUMNS = new int[]{555, 556, 557, 511, 527, 509, 598, 525, 507, 540, 526, 508, 539, 523, 506, 538, 528, 510, 541};

    public BasicCensoredContactTemplateTest() {
    }

    public BasicCensoredContactTemplateTest(String name) {
        super(name);
    }

    @Override
    public Contact generateContact(String identifier) {
        Contact contact = new Contact();
        contact.setGivenName("givenname" + identifier);
        contact.setSurName("surname" + identifier);
        contact.setMiddleName("middlename" + identifier);
        contact.setPosition("position" + identifier);
        contact.setTitle("title" + identifier);
        contact.setCompany("company" + identifier);
        return contact;
    }

    public void testShouldNotPublishCensoredFields() throws Exception {
        SubscriptionSource source = this.getSubscriptionSource();
        MicroformatSubscribeService service = this.getSubscribeService();
        this.introduceToEachOther(service, source);
        StringWriter writer = new StringWriter();
        Contact expected = this.generateContact("");
        expected.setEmail1("this-will-need-to-be-censored-1@open-xchange.invalid");
        expected.setEmail2("this-will-need-to-be-censored-2@open-xchange.invalid");
        expected.setEmail3("this-will-need-to-be-censored-3@open-xchange.invalid");
        expected.setBirthday(new Date());
        expected.setStreetBusiness("street_business");
        expected.setPostalCodeBusiness("postal_code_business");
        expected.setCityBusiness("city_business");
        expected.setCountryBusiness("country_business");
        expected.setStreetHome("street_home");
        expected.setPostalCodeHome("postal_code_home");
        expected.setCityHome("city_home");
        expected.setCountryHome("country_home");
        expected.setStreetOther("street_other");
        expected.setPostalCodeOther("postal_code_other");
        expected.setCityOther("city_other");
        expected.setCountryOther("country_other");
        List<Contact> expecteds = Arrays.asList(expected);
        OXTemplate templ = this.getTemplate();
        Map<String, Object> variables = this.getVariables();
        variables.put("contacts", expecteds);
        templ.process(variables, (Writer)writer);
        String htmlData = writer.toString();
        Collection actuals = service.getContent((Reader)new StringReader(htmlData));
        BasicCensoredContactTemplateTest.assertEquals((String)"Should return one contact", (int)1, (int)actuals.size());
        Contact actual = (Contact)actuals.iterator().next();
        for (int field : CENSORED_COLUMNS) {
            BasicCensoredContactTemplateTest.assertNull((String)("This field needs to be censored: #" + field), (Object)actual.get(field));
        }
    }
}

