/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.activation.DataHandler;

public final class MailGetTest
extends MessageStorageTest {
    private static char linebreak = (char)10;
    private final String brokenContentTypeMail = "Return-Path: <schweigi@open-xchange.com>" + linebreak + "Date: Thu, 20 Sep 2007 11:01:25 +0200" + linebreak + "From: Thomas Schweiger <schweigi@open-xchange.com>" + linebreak + "To: Thomas Schweiger <schweigi@open-xchange.com>" + linebreak + "Subject: test PGP signed mail" + linebreak + "Message-ID: <20070920090125.GA12567@open-xchange.com>" + linebreak + "Mime-Version: 1.0" + linebreak + "Content-Type: multipart/signed; micalg=pgp-sha1; protocol=\"application/pgp-signature\" boundary=\"mP3DRpeJDSE+ciuQ\"" + linebreak + "Content-Disposition: inline" + linebreak + "X-Operating-System: SUSE LINUX" + linebreak + "X-Mailer: Open-Xchange v6.0 Console Mailer" + linebreak + "X-PGP-Key: 1024D/D532F2E8" + linebreak + "X-PGP-Fingerprint: 815B 2A54 E23A FEF9 1AED 6CF9 2603 813F D532 F2E8" + linebreak + "X-Message-Flag: \"Es ist Wahnsinn, das Leben so zu sehen wie es ist, anstatt es zu sehen wie es sein sollte.\"" + linebreak + "X-Private-URL1: http://www.schweigisito.de" + linebreak + "X-Private-URL2: http://www.straight-live.de" + linebreak + linebreak + linebreak + "--mP3DRpeJDSE+ciuQ" + linebreak + "Content-Type: text/plain; charset=us-ascii" + linebreak + "Content-Disposition: inline" + linebreak + linebreak + "This mail contains a PGP signature." + linebreak + linebreak + linebreak + "--mP3DRpeJDSE+ciuQ" + linebreak + "Content-Type: application/pgp-signature" + linebreak + "Content-Disposition: inline" + linebreak + linebreak + "-----BEGIN PGP SIGNATURE-----" + linebreak + "Version: GnuPG v1.4.2 (GNU/Linux)" + linebreak + linebreak + "iD8DBQFG8jblJgOBP9Uy8ugRAp4+AJ9iAZcBh6ke0zrqkrtLMWH+QKfTGgCffF+5" + linebreak + "F2P9TrHERgiiyRTA6x6BR2U=" + linebreak + "=Wk8C" + linebreak + "-----END PGP SIGNATURE-----" + linebreak + linebreak + "--mP3DRpeJDSE+ciuQ--" + linebreak;
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.BODY};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY, MailField.SENT_DATE, MailField.RECEIVED_DATE, MailField.CC, MailField.BCC, MailField.FOLDER_ID};
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};

    public void testMailGetNotExistingMails() throws OXException {
        try {
            MailMessage message = this.mailAccess.getMessageStorage().getMessage("INBOX", String.valueOf(System.currentTimeMillis()), true);
            MailGetTest.assertTrue((String)"The message for an invalid id must be null", (null == message ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MailGetTest.fail((String)("getMessage throws an exception: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailGetNotExistingFolder() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            MailGetTest.assertNull((String)"No mail should be returned on a invalid folder", (Object)this.mailAccess.getMessageStorage().getMessage("Ichbinnichda1337", String.valueOf(System.currentTimeMillis()), true));
        }
        catch (OXException e) {
            MailGetTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailGet() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            int i;
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailGetTest.assertFalse((String)"Mail ID is -1", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
            }
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailGetTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailGetTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailGetTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                    MailGetTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                    continue;
                }
                MailGetTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
            }
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_EVEN_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailGetTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailGetTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailGetTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailGetTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                MailGetTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                MailGetTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                MailGetTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                MailGetTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                MailGetTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                MailGetTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                MailGetTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                MailGetTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                MailGetTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                MailGetTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                MailGetTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                MailGetTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                MailGetTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
            }
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_FULL);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailGetTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailGetTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailGetTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailGetTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                MailGetTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                MailGetTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                MailGetTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                MailGetTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                MailGetTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                MailGetTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                MailGetTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                MailGetTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                MailGetTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                MailGetTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                MailGetTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                MailGetTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                MailGetTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
                MailGetTest.assertTrue((String)"Missing account name", (boolean)fetchedMails[i].containsAccountName());
                if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                    MailGetTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                    continue;
                }
                MailGetTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailGetBrokenContentTypeList() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", new MailMessage[]{new TestMailMessage()});
        try {
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_MORE);
            for (int i = 0; i < fetchedMails.length; ++i) {
                MailGetTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailGetTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailGetTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailGetTest.assertTrue((String)"Message must contain attachment information but signal no attachment", (fetchedMails[i].containsHasAttachment() && !fetchedMails[i].hasAttachment() ? 1 : 0) != 0);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailGetBrokenContentTypeGet() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", new MailMessage[]{new TestMailMessage()});
        try {
            MailMessage fetchedMails = this.mailAccess.getMessageStorage().getMessage("INBOX", uids[0], true);
            MailGetTest.assertFalse((String)"Missing mail ID", (fetchedMails.getMailId() == null ? 1 : 0) != 0);
            MailGetTest.assertTrue((String)"Missing content type", (boolean)fetchedMails.containsContentType());
            MailGetTest.assertTrue((String)"Missing flags", (boolean)fetchedMails.containsFlags());
            MailGetTest.assertTrue((String)"Message must contain attachment information but signal no attachment", (fetchedMails.containsHasAttachment() && !fetchedMails.hasAttachment() ? 1 : 0) != 0);
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    private class TestMailMessage
    extends MailMessage {
        private static final long serialVersionUID = 4645951099640670488L;

        private TestMailMessage() {
        }

        public String getMailId() {
            return null;
        }

        public int getUnreadMessages() {
            return 0;
        }

        public void setMailId(String id) {
        }

        public void setUnreadMessages(int unreadMessages) {
        }

        public Object getContent() throws OXException {
            return null;
        }

        public DataHandler getDataHandler() throws OXException {
            return null;
        }

        public int getEnclosedCount() throws OXException {
            return 0;
        }

        public MailPart getEnclosedMailPart(int index) throws OXException {
            return null;
        }

        public InputStream getInputStream() throws OXException {
            return new ByteArrayInputStream(MailGetTest.this.brokenContentTypeMail.getBytes());
        }

        public void loadContent() throws OXException {
        }

        public void prepareForCaching() {
        }
    }
}

