/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.api2.ContactSQLInterface;
import com.openexchange.contact.LdapServer;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactSearchMultiplexer;
import com.openexchange.groupware.contact.ContactUnificationState;
import com.openexchange.groupware.contact.SimContactInterfaceDiscoveryService;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.search.SearchTerm;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SimServerSession;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class ContactSearchMuliplexerTest
extends TestCase {
    private ContactSearchMultiplexer searchMultiplexer;
    private SimServerSession session;

    protected void setUp() throws Exception {
        super.setUp();
        ContactSQLInterface iface1 = this.contactsWithSearchResult(11, 12, 13);
        ContactSQLInterface iface2 = this.contactsWithSearchResult(21, 22, 23);
        ContactSQLInterface iface3 = this.contactsWithSearchResult(31, 32, 33);
        ContactSQLInterface standard = this.contactsWithSearchResult(1, 2, 3);
        SimContactInterfaceDiscoveryService discoveryService = new SimContactInterfaceDiscoveryService();
        discoveryService.register((ContactInterface)iface1, 1);
        discoveryService.register((ContactInterface)iface2, 2);
        discoveryService.register((ContactInterface)iface3, 3);
        discoveryService.setDefaultContactInterface((ContactInterface)standard);
        this.searchMultiplexer = new ContactSearchMultiplexer((ContactInterfaceDiscoveryService)discoveryService);
        this.session = new SimServerSession((Context)new SimContext(1), null, null);
    }

    public void testSearchInSpecificFolders() throws Exception {
        ContactSearchObject contactSearchObject = new ContactSearchObject();
        contactSearchObject.addFolder(1);
        contactSearchObject.addFolder(3);
        contactSearchObject.addFolder(1337);
        SearchIterator contacts = this.searchMultiplexer.extendedSearch((ServerSession)this.session, contactSearchObject, 1, Order.ASCENDING, null, new int[]{1});
        ContactSearchMuliplexerTest.assertNotNull((Object)contacts);
        this.assertIDs((SearchIterator<Contact>)contacts, 1, 2, 3, 11, 12, 13, 31, 32, 33);
    }

    public void testSearchEverywhere() throws Exception {
        ContactSearchObject contactSearchObject = new ContactSearchObject();
        SearchIterator contacts = this.searchMultiplexer.extendedSearch((ServerSession)this.session, contactSearchObject, 1, Order.ASCENDING, null, new int[]{1});
        ContactSearchMuliplexerTest.assertNotNull((Object)contacts);
        this.assertIDs((SearchIterator<Contact>)contacts, 1, 2, 3, 11, 12, 13, 21, 22, 23, 31, 32, 33);
    }

    private void assertIDs(SearchIterator<Contact> results, int ... ids) throws Exception {
        int index = 0;
        while (results.hasNext()) {
            Contact c = (Contact)results.next();
            int currentId = ids[index++];
            ContactSearchMuliplexerTest.assertEquals((String)("Unexpected element at index: " + (index - 1)), (int)currentId, (int)c.getObjectID());
        }
        ContactSearchMuliplexerTest.assertEquals((int)ids.length, (int)index);
    }

    private ContactSQLInterface contactsWithSearchResult(int ... ids) {
        final LinkedList<Contact> contacts = new LinkedList<Contact>();
        for (int id : ids) {
            Contact contact = new Contact();
            contact.setObjectID(id);
            contacts.add(contact);
        }
        return new ContactSQLInterface(){

            public void deleteContactObject(int objectId, int inFolder, Date clientLastModified) throws OXException, OXException, OXException {
            }

            public void insertContactObject(Contact contactObj) throws OXException {
            }

            public void updateContactObject(Contact contactObj, int inFolder, Date clientLastModified) throws OXException, OXException {
            }

            public void updateUserContact(Contact contact, Date lastmodified) throws OXException {
            }

            public SearchIterator<Contact> getContactsByExtendedSearch(ContactSearchObject searchobject, int orderBy, Order order, String collation, int[] cols) throws OXException {
                return new SearchIteratorAdapter(contacts.iterator());
            }

            public SearchIterator<Contact> getContactsInFolder(int folderId, int from, int to, int orderBy, Order order, String collation, int[] cols) throws OXException {
                return null;
            }

            public SearchIterator<Contact> getDeletedContactsInFolder(int folderId, int[] cols, Date since) throws OXException {
                return null;
            }

            public int getFolderId() {
                return 0;
            }

            public LdapServer getLdapServer() {
                return null;
            }

            public SearchIterator<Contact> getModifiedContactsInFolder(int folderId, int[] cols, Date since) throws OXException {
                return null;
            }

            public int getNumberOfContacts(int folderId) throws OXException {
                return 0;
            }

            public Contact getObjectById(int objectId, int inFolder) throws OXException {
                return null;
            }

            public SearchIterator<Contact> getObjectsById(int[][] objectIdAndInFolder, int[] cols) throws OXException {
                return null;
            }

            public Contact getUserById(int userId, boolean performReadCheck) throws OXException {
                return null;
            }

            public Contact[] getUsersById(int[] userIds, boolean performReadCheck) throws OXException {
                return null;
            }

            public Contact getUserById(int userId) throws OXException {
                return null;
            }

            public SearchIterator<Contact> searchContacts(String searchpattern, int folderId, int orderBy, Order order, int[] cols) throws OXException {
                return null;
            }

            public void associateTwoContacts(Contact master, Contact slave) throws OXException {
            }

            public List<Contact> getAssociatedContacts(Contact contact) throws OXException {
                return null;
            }

            public ContactUnificationState getAssociationBetween(Contact c1, Contact c2) throws OXException {
                return null;
            }

            public Contact getContactByUUID(String uuid) throws OXException {
                return null;
            }

            public void separateTwoContacts(Contact master, Contact slave) throws OXException {
            }

            public <T> SearchIterator<Contact> getContactsByExtendedSearch(SearchTerm<T> searchterm, int orderBy, Order order, String collation, int[] cols) throws OXException {
                return new SearchIteratorAdapter(contacts.iterator());
            }
        };
    }
}

