/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.CalendarObject;
import java.util.Date;

public class Bug11695Test
extends CalendarSqlTest {
    public void testShouldCalculateProperWeeklyRecurrence() throws OXException {
        Date start = CommonAppointments.D("04/09/2008 22:00");
        Date end = CommonAppointments.D("04/09/2008 23:00");
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
        appointment.setRecurrenceType(2);
        appointment.setDays(34);
        appointment.setTitle("testShouldCalculateProperWeeklyRecurrence");
        appointment.setInterval(1);
        appointment.setOccurrence(2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        RecurringResultsInterface results = this.getTools().calculateRecurring((CalendarObject)appointment, 0L, 0L, 0);
        Bug11695Test.assertEquals((String)"Unexpected size in recurring results of weekly recurrence appointment", (int)2, (int)results.size());
        RecurringResultInterface firstResult = results.getRecurringResult(0);
        Bug11695Test.assertEquals((String)"Unexpected first occurrence", (Object)CommonAppointments.D("05/09/2008 22:00"), (Object)new Date(firstResult.getStart()));
        RecurringResultInterface secondResult = results.getRecurringResult(1);
        Bug11695Test.assertEquals((String)"Unexpected second occurrence", (Object)CommonAppointments.D("08/09/2008 22:00"), (Object)new Date(secondResult.getStart()));
    }

    public void testShouldCalculateProperWeeklyRecurrence2() throws OXException {
        Date start = CommonAppointments.D("14/09/2008 22:00");
        Date end = CommonAppointments.D("14/09/2008 23:00");
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
        appointment.setRecurrenceType(2);
        appointment.setDays(62);
        appointment.setTitle("testShouldCalculateProperWeeklyRecurrence2");
        appointment.setInterval(1);
        appointment.setUntil(new Date(1222041600000L));
        this.appointments.save(appointment);
        this.clean.add(appointment);
        long[] expectedLongs = new long[]{CommonAppointments.D("15/09/2008 22:00").getTime(), CommonAppointments.D("16/09/2008 22:00").getTime(), CommonAppointments.D("17/09/2008 22:00").getTime(), CommonAppointments.D("18/09/2008 22:00").getTime(), CommonAppointments.D("19/09/2008 22:00").getTime(), CommonAppointments.D("22/09/2008 22:00").getTime()};
        RecurringResultsInterface results = this.getTools().calculateRecurring((CalendarObject)appointment, 0L, 0L, 0);
        Bug11695Test.assertEquals((String)"Unexpected size in recurring results of weekly recurrence appointment", (int)expectedLongs.length, (int)results.size());
        for (int i = 0; i < expectedLongs.length; ++i) {
            Bug11695Test.assertEquals((String)("Unexpected " + (i + 1) + " occurrence"), (Object)new Date(expectedLongs[i]), (Object)new Date(results.getRecurringResult(i).getStart()));
        }
    }
}

