/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.actions.AbstractAttachmentActionTest;
import com.openexchange.groupware.attach.impl.CreateAttachmentAction;
import com.openexchange.groupware.attach.impl.DeleteAttachmentAction;
import com.openexchange.tx.UndoableAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RemoveAttachmentsActionTest
extends AbstractAttachmentActionTest {
    private final CreateAttachmentAction createAction = new CreateAttachmentAction();
    private int delCountStart;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createAction.setAttachments(this.getAttachments());
        this.createAction.setQueryCatalog(this.getQueryCatalog());
        this.createAction.setProvider(this.getProvider());
        this.createAction.setContext(this.getContext());
        this.createAction.perform();
        this.delCountStart = this.countDel();
    }

    @Override
    public void tearDown() throws Exception {
        this.createAction.undo();
        super.tearDown();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        DeleteAttachmentAction deleteAction = new DeleteAttachmentAction();
        deleteAction.setAttachments(this.getAttachments());
        deleteAction.setQueryCatalog(this.getQueryCatalog());
        deleteAction.setProvider(this.getProvider());
        deleteAction.setContext(this.getContext());
        return deleteAction;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        this.checkDelTable();
        this.checkRemovedFromNormalTable();
    }

    @Override
    protected void verifyUndone() throws Exception {
        for (AttachmentMetadata attachment : this.getAttachments()) {
            AttachmentMetadata loaded = this.getAttachmentBase().getAttachment(attachment.getFolderId(), attachment.getAttachedId(), attachment.getModuleId(), attachment.getId(), this.getContext(), this.getUser(), null);
            RemoveAttachmentsActionTest.assertEquals(attachment, loaded);
        }
        this.checkRemovedFromDel();
    }

    private void checkRemovedFromNormalTable() {
        for (AttachmentMetadata attachment : this.getAttachments()) {
            try {
                this.getAttachmentBase().getAttachment(attachment.getFolderId(), attachment.getAttachedId(), attachment.getModuleId(), attachment.getId(), this.getContext(), this.getUser(), null);
                RemoveAttachmentsActionTest.fail((String)"Found attachment");
            }
            catch (OXException x) {
                RemoveAttachmentsActionTest.assertTrue((boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countDel() throws OXException, SQLException {
        StringBuilder in = new StringBuilder();
        for (AttachmentMetadata m : this.getAttachments()) {
            in.append(m.getId()).append(',');
        }
        in.setLength(in.length() - 1);
        Connection readCon = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getProvider().getReadConnection(this.getContext());
            stmt = readCon.prepareStatement("SELECT count(*) FROM del_attachment WHERE cid = ? and id in (" + in.toString() + ")");
            stmt.setInt(1, this.getContext().getContextId());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (readCon != null) {
                this.getProvider().releaseReadConnection(this.getContext(), readCon);
            }
        }
    }

    private void checkDelTable() throws OXException, SQLException {
        RemoveAttachmentsActionTest.assertEquals((int)this.getAttachments().size(), (int)(this.countDel() - this.delCountStart));
    }

    private void checkRemovedFromDel() throws OXException, SQLException {
        RemoveAttachmentsActionTest.assertEquals((int)this.delCountStart, (int)this.countDel());
    }
}

