/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.actions.AbstractAttachmentEventActionTest;
import com.openexchange.groupware.attach.impl.FireAttachedEventAction;
import com.openexchange.tx.UndoableAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FireAttachedEventActionTest
extends AbstractAttachmentEventActionTest {
    private final AbstractAttachmentEventActionTest.MockAttachmentListener listener = new AbstractAttachmentEventActionTest.MockAttachmentListener();
    private AbstractAttachmentEventActionTest.MockDBProvider provider = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.provider = new AbstractAttachmentEventActionTest.MockDBProvider((DBProvider)new DBPoolProvider());
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        FireAttachedEventAction fireAttached = new FireAttachedEventAction();
        fireAttached.setAttachments(this.getAttachments());
        fireAttached.setSession(this.getSession());
        fireAttached.setContext(this.getContext());
        fireAttached.setUser(this.getUser());
        fireAttached.setUserConfiguration(null);
        fireAttached.setProvider((DBProvider)this.provider);
        ArrayList<AbstractAttachmentEventActionTest.MockAttachmentListener> listeners = new ArrayList<AbstractAttachmentEventActionTest.MockAttachmentListener>();
        listeners.add(this.listener);
        fireAttached.setAttachmentListeners(listeners);
        fireAttached.setSource(this.getAttachmentBase());
        return fireAttached;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        List<AttachmentMetadata> m = this.listener.getAttached();
        HashMap<Integer, AttachmentMetadata> attachmentMap = new HashMap<Integer, AttachmentMetadata>();
        HashSet<AttachmentMetadata> attachmentSet = new HashSet<AttachmentMetadata>();
        for (AttachmentMetadata att : this.getAttachments()) {
            attachmentMap.put(att.getId(), att);
            attachmentSet.add(att);
        }
        for (AttachmentMetadata attached : m) {
            AttachmentMetadata orig = (AttachmentMetadata)attachmentMap.get(attached.getId());
            FireAttachedEventActionTest.assertEquals(orig, attached);
            FireAttachedEventActionTest.assertTrue((boolean)attachmentSet.remove(attached));
        }
        FireAttachedEventActionTest.assertTrue((boolean)attachmentSet.isEmpty());
        this.listener.clear();
        FireAttachedEventActionTest.assertTrue((String)this.provider.getStatus(), (boolean)this.provider.allOK());
        FireAttachedEventActionTest.assertTrue((String)this.provider.getStatus(), (boolean)this.provider.called());
    }

    @Override
    protected void verifyUndone() throws Exception {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (AttachmentMetadata m : this.getAttachments()) {
            ids.add(m.getId());
        }
        Iterator<Object> i$ = this.listener.getDetached().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            FireAttachedEventActionTest.assertTrue((boolean)ids.remove(id));
        }
        FireAttachedEventActionTest.assertTrue((boolean)ids.isEmpty());
        FireAttachedEventActionTest.assertTrue((boolean)this.provider.allOK());
        FireAttachedEventActionTest.assertTrue((boolean)this.provider.called());
    }
}

