/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.api2.RdbFolderSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderTools;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(FolderTest.class);
    public static final int CONTEXT_ID = 1337;
    private static boolean init = false;
    private SessionObject session;
    private Context ctx;
    private int userId;

    private static int resolveUser(String user, Context ctx) throws Exception {
        try {
            int pos = -1;
            pos = user.indexOf(64);
            user = pos > -1 ? user.substring(0, pos) : user;
            UserStorage uStorage = UserStorage.getInstance();
            return uStorage.getUserId(user, ctx);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!init) {
            Init.startServer();
        }
        this.ctx = new ContextImpl(1337);
        this.userId = FolderTest.resolveUser(AjaxInit.getAJAXProperty("login"), this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.userId, (int)1337, (String)"thorben_session_id");
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    public AppointmentSQLInterface getAppointmentHandler() {
        return ((AppointmentSqlFactoryService)ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class)).createAppointmentSql((Session)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderInsertSuccess() throws Throwable {
        int userId = this.session.getUserId();
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        int fuid = -1;
        try {
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(2);
            fo.setType(1);
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            fo.setPermissionsAsArray(new OCLPermission[]{ocl});
            fuid = oxma.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
            FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
            FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
            FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
            FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
            FolderTest.assertTrue((boolean)fo.containsCreationDate());
            FolderTest.assertTrue((boolean)fo.containsLastModified());
            oxma.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
            fuid = -1;
            FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
            FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
        finally {
            if (fuid != -1) {
                try {
                    oxma.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void testFolderInsertFail001() {
        try {
            int userId = this.session.getUserId();
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(2);
            fo.setType(1);
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId - 2);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            fo.setPermissionsAsArray(new OCLPermission[]{ocl});
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
            Exception exc = null;
            try {
                oxma.createFolder(fo, true, System.currentTimeMillis());
            }
            catch (Exception e) {
                exc = e;
            }
            FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            if (fo.containsObjectID() && fo.getObjectID() != -1) {
                oxma.deleteFolder(fo, true, System.currentTimeMillis());
                FolderTest.fail((String)"Exception expected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public void testFolderInsertFail002() {
        try {
            int userId = this.session.getUserId();
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(2);
            fo.setType(1);
            ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            perms.add(ocl);
            ocl = new OCLPermission();
            ocl.setEntity(FolderTest.resolveUser(AjaxInit.getAJAXProperty("seconduser"), this.ctx));
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            perms.add(ocl);
            fo.setPermissions(perms);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
            Exception exc = null;
            try {
                oxma.createFolder(fo, true, System.currentTimeMillis());
            }
            catch (Exception e) {
                exc = e;
            }
            FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            if (fo.containsObjectID() && fo.getObjectID() != -1) {
                oxma.deleteFolder(fo, true, System.currentTimeMillis());
                FolderTest.fail((String)"Exception expected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public void testFolderInsertFail003() {
        try {
            int userId = this.session.getUserId();
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(2);
            fo.setType(2);
            ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            perms.add(ocl);
            fo.setPermissions(perms);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
            int fuid = -1;
            Exception exc = null;
            try {
                fuid = oxma.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
            }
            catch (Exception e) {
                exc = e;
            }
            FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            if (fo.containsObjectID() && fuid != -1) {
                oxma.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderTest.fail((String)"Exception expected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public void testFolderInsertFail004() {
        try {
            int userId = this.session.getUserId();
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(8);
            fo.setType(1);
            ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            perms.add(ocl);
            fo.setPermissions(perms);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
            int fuid = -1;
            Exception exc = null;
            try {
                fuid = oxma.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
            }
            catch (Exception e) {
                exc = e;
            }
            FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            if (fuid != -1) {
                oxma.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderTest.fail((String)"Exception expected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public void testFolderInsertFail005() {
        try {
            int userId = this.session.getUserId();
            FolderObject fo = new FolderObject();
            fo.setFolderName("NewCalendarTestFolder");
            fo.setParentFolderID(1);
            fo.setModule(2);
            fo.setType(1);
            ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
            OCLPermission ocl = new OCLPermission();
            ocl.setEntity(userId);
            ocl.setAllPermission(128, 128, 128, 128);
            ocl.setGroupPermission(false);
            ocl.setFolderAdmin(true);
            perms.add(ocl);
            int secondUser = FolderTest.resolveUser(AjaxInit.getAJAXProperty("seconduser"), this.ctx);
            OCLPermission ocl2 = new OCLPermission();
            ocl2.setEntity(secondUser);
            ocl2.setAllPermission(2, 4, 0, 0);
            ocl2.setGroupPermission(false);
            ocl2.setFolderAdmin(false);
            perms.add(ocl2);
            ocl2 = new OCLPermission();
            ocl2.setEntity(secondUser);
            ocl2.setAllPermission(2, 4, 0, 0);
            ocl2.setGroupPermission(false);
            ocl2.setFolderAdmin(false);
            perms.add(ocl2);
            fo.setPermissions(perms);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
            int fuid = -1;
            Exception exc = null;
            try {
                fuid = oxma.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
            }
            catch (Exception e) {
                exc = e;
            }
            FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            if (fuid != -1) {
                oxma.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderTest.fail((String)"Exception expected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateFolderSuccessRename() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(1);
                fo.setModule(2);
                fo.setType(1);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                fuid = oxfa.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
                FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
                FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((boolean)fo.containsCreationDate());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                fo.reset();
                fo.setObjectID(fuid);
                fo.setFolderName("NewCalendarTestFolderRenamed");
                long lastModified = System.currentTimeMillis();
                fo = oxfa.updateFolder(fo, true, System.currentTimeMillis());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                FolderTest.assertTrue((boolean)fo.containsModifiedBy());
                FolderTest.assertTrue((fo.getLastModified().getTime() == lastModified ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
                throw throwable;
            }
            oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
            FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
            FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateFolderSuccessMove() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(1);
                fo.setModule(2);
                fo.setType(1);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                fuid = oxfa.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
                FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
                FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((boolean)fo.containsCreationDate());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                int stdCalFolder = OXFolderTools.getCalendarDefaultFolder((int)userId, (Context)this.ctx);
                fo.reset();
                fo.setObjectID(fuid);
                fo.setParentFolderID(stdCalFolder);
                long lastModified = System.currentTimeMillis();
                fo = oxfa.updateFolder(fo, true, System.currentTimeMillis());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                FolderTest.assertTrue((boolean)fo.containsModifiedBy());
                FolderTest.assertTrue((fo.getLastModified().getTime() == lastModified ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getParentFolderID() == stdCalFolder ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
                throw throwable;
            }
            oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
            FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
            FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateFolderSuccessRenameMove() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(1);
                fo.setModule(2);
                fo.setType(1);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                fuid = oxfa.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
                FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
                FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((boolean)fo.containsCreationDate());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                int stdCalFolder = OXFolderTools.getCalendarDefaultFolder((int)userId, (Context)this.ctx);
                fo.reset();
                fo.setObjectID(fuid);
                fo.setParentFolderID(stdCalFolder);
                fo.setFolderName("AARRGGH!");
                long lastModified = System.currentTimeMillis();
                fo = oxfa.updateFolder(fo, true, System.currentTimeMillis());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                FolderTest.assertTrue((boolean)fo.containsModifiedBy());
                FolderTest.assertTrue((fo.getLastModified().getTime() == lastModified ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getParentFolderID() == stdCalFolder ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
                throw throwable;
            }
            oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
            FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
            FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateFolderSuccessAll() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(1);
                fo.setModule(2);
                fo.setType(1);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                fuid = fo.getObjectID();
                FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
                FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((boolean)fo.containsCreationDate());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                int stdCalFolder = OXFolderTools.getCalendarDefaultFolder((int)userId, (Context)this.ctx);
                int secondUserId = FolderTest.resolveUser(AjaxInit.getAJAXProperty("seconduser"), this.ctx);
                fo.reset();
                fo.setObjectID(fuid);
                fo.setParentFolderID(stdCalFolder);
                fo.setFolderName("Shared_AARRGGH!");
                ArrayList<OCLPermission> perms = new ArrayList<OCLPermission>();
                OCLPermission updateOCL = new OCLPermission();
                updateOCL.setEntity(userId);
                updateOCL.setAllPermission(128, 128, 128, 128);
                updateOCL.setGroupPermission(false);
                updateOCL.setFolderAdmin(true);
                perms.add(updateOCL);
                updateOCL = new OCLPermission();
                updateOCL.setEntity(secondUserId);
                updateOCL.setAllPermission(128, 128, 128, 128);
                updateOCL.setGroupPermission(false);
                updateOCL.setFolderAdmin(false);
                perms.add(updateOCL);
                fo.setPermissions(perms);
                long lastModified = System.currentTimeMillis();
                oxfa.updateFolder(fo, true, System.currentTimeMillis());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                FolderTest.assertTrue((boolean)fo.containsModifiedBy());
                FolderTest.assertTrue((fo.getLastModified().getTime() == lastModified ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getParentFolderID() == stdCalFolder ? 1 : 0) != 0);
                EffectivePermission ep = fo.getEffectiveUserPermission(secondUserId, RdbUserConfigurationStorage.loadUserConfiguration((int)secondUserId, (Context)new ContextImpl(1337)));
                FolderTest.assertTrue((boolean)ep.isFolderVisible());
                FolderTest.assertTrue((boolean)ep.canCreateSubfolders());
                FolderTest.assertTrue((boolean)ep.canDeleteAllObjects());
                FolderTest.assertTrue((boolean)ep.canWriteAllObjects());
                FolderTest.assertTrue((boolean)ep.canReadAllObjects());
                FolderTest.assertFalse((boolean)ep.isFolderAdmin());
            }
            catch (Throwable throwable) {
                oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
                throw throwable;
            }
            oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
            FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
            FolderTest.assertTrue((tmp == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFolder() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(1);
                fo.setModule(2);
                fo.setType(1);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                fo = oxfa.createFolder(fo, true, System.currentTimeMillis());
                fuid = fo.getObjectID();
                FolderTest.assertTrue((fuid > 0 ? 1 : 0) != 0);
                FolderTest.assertTrue((fuid == fo.getObjectID() ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getCreatedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((fo.getModifiedBy() == userId ? 1 : 0) != 0);
                FolderTest.assertTrue((boolean)fo.containsCreationDate());
                FolderTest.assertTrue((boolean)fo.containsLastModified());
                fo.reset();
                fo.setFolderName("NewContactTestSubFolder001");
                fo.setParentFolderID(fuid);
                fo.setModule(3);
                fo.setType(1);
                ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                fo.reset();
                fo.setFolderName("NewTaskTestSubFolder002");
                fo.setParentFolderID(fuid);
                fo.setModule(1);
                fo.setType(1);
                ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                int subfolderId = -1;
                fo.reset();
                fo.setFolderName("NewCalendarTestSubFolder003");
                fo.setParentFolderID(fuid);
                fo.setModule(2);
                fo.setType(1);
                ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                subfolderId = oxfa.createFolder(fo, true, System.currentTimeMillis()).getObjectID();
                fo.reset();
                fo.setFolderName("NewContactTestSubSubFolder001");
                fo.setParentFolderID(subfolderId);
                fo.setModule(3);
                fo.setType(1);
                ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                long lastModified = System.currentTimeMillis();
                try {
                    oxfa.deleteFolder(new FolderObject(fuid), true, lastModified);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FolderTest.fail((String)e.getMessage());
                }
                fo.reset();
                fo.setObjectID(fuid);
                FolderTest.assertFalse((boolean)fo.exists(this.ctx));
            }
            finally {
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                if (tmp != null) {
                    oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public static final UserConfiguration getUserConfiguration(Context ctx, int userId) throws OXException {
        UserConfigurationStorage stor = UserConfigurationStorage.getInstance();
        return stor.getUserConfiguration(userId, ctx);
    }

    public static final void saveUserConfiguration(UserConfiguration uc) throws OXException {
        UserConfigurationStorage stor = UserConfigurationStorage.getInstance();
        stor.saveUserConfiguration(uc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithModifiedUserConfig001() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(2);
                fo.setModule(2);
                fo.setType(2);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                try {
                    oxfa.createFolder(fo, true, System.currentTimeMillis());
                    fuid = fo.getObjectID();
                }
                catch (Exception e) {
                    if (fuid > 0) {
                        oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                    }
                    FolderTest.fail((String)e.getMessage());
                }
                UserConfiguration uc = FolderTest.getUserConfiguration(this.ctx, userId);
                uc.setFullPublicFolderAccess(false);
                FolderTest.saveUserConfiguration(uc);
                fo.setFolderName("NewCalendarTestFolder_Changed");
                Exception exc = null;
                try {
                    fo = oxfa.updateFolder(fo, true, System.currentTimeMillis());
                }
                catch (Exception e) {
                    exc = e;
                }
                FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            }
            finally {
                UserConfiguration uc = FolderTest.getUserConfiguration(this.ctx, userId);
                uc.setFullPublicFolderAccess(true);
                FolderTest.saveUserConfiguration(uc);
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                if (tmp != null) {
                    oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithModifiedUserConfig002() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(2);
                fo.setModule(2);
                fo.setType(2);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                fuid = fo.getObjectID();
                UserConfiguration uc = FolderTest.getUserConfiguration(this.ctx, userId);
                uc.setCalendar(false);
                FolderTest.saveUserConfiguration(uc);
                fo.setFolderName("NewCalendarTestFolder_Changed");
                Exception exc = null;
                try {
                    fo = oxfa.updateFolder(fo, true, System.currentTimeMillis());
                }
                catch (Exception e) {
                    exc = e;
                }
                FolderTest.assertTrue((exc != null ? 1 : 0) != 0);
            }
            finally {
                UserConfiguration uc = FolderTest.getUserConfiguration(this.ctx, userId);
                uc.setCalendar(true);
                FolderTest.saveUserConfiguration(uc);
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                if (tmp != null) {
                    oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderCleaning() {
        try {
            int userId = this.session.getUserId();
            int fuid = -1;
            OXFolderManager oxfa = null;
            try {
                FolderObject fo = new FolderObject();
                fo.setFolderName("NewCalendarTestFolder");
                fo.setParentFolderID(2);
                fo.setModule(2);
                fo.setType(2);
                OCLPermission ocl = new OCLPermission();
                ocl.setEntity(userId);
                ocl.setAllPermission(128, 128, 128, 128);
                ocl.setGroupPermission(false);
                ocl.setFolderAdmin(true);
                fo.setPermissionsAsArray(new OCLPermission[]{ocl});
                oxfa = OXFolderManager.getInstance((Session)this.session);
                oxfa.createFolder(fo, true, System.currentTimeMillis());
                fuid = fo.getObjectID();
                CalendarDataObject cdao = new CalendarDataObject();
                cdao.setTitle("testInsertAndAlarm - Step 1 - Insert");
                cdao.setParentFolderID(fuid);
                cdao.setContext(this.ctx);
                cdao.setIgnoreConflicts(true);
                UserParticipant up = new UserParticipant(this.session.getUserId());
                up.setAlarmMinutes(5);
                cdao.setUsers(new UserParticipant[]{up});
                Participants participants = new Participants();
                UserParticipant p = new UserParticipant(this.session.getUserId());
                participants.add((Participant)p);
                String user2 = AbstractConfigWrapper.parseProperty((Properties)FolderTest.getAJAXProperties(), (String)"user_participant3", (String)"");
                UserParticipant p2 = new UserParticipant(FolderTest.resolveUser(user2, this.ctx));
                participants.add((Participant)p2);
                cdao.setParticipants(participants.getList());
                FolderTest.fillDatesInDao((Appointment)cdao);
                AppointmentSQLInterface csql = this.getAppointmentHandler();
                csql.insertAppointmentObject(cdao);
                int object_id = cdao.getObjectID();
                csql.getObjectById(object_id, fuid);
                try {
                    OXFolderManager.getInstance((Session)this.session).clearFolder(fo, true, System.currentTimeMillis());
                }
                catch (Exception e) {
                    FolderTest.fail((String)e.getMessage());
                }
                FolderTest.assertTrue((boolean)true);
            }
            finally {
                FolderObject tmp = FolderCacheManager.getInstance().getFolderObject(fuid, this.ctx);
                if (tmp != null) {
                    oxfa.deleteFolder(new FolderObject(fuid), true, System.currentTimeMillis());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    private static final void fillDatesInDao(Appointment cdao) {
        long s;
        long cals = s = System.currentTimeMillis();
        long calsmod = s % 86400000L;
        cals -= calsmod;
        long endcalc = 3600000L;
        long mod = s % 3600000L;
        long e = (s -= mod) + 3600000L;
        long u = s + 864000000L;
        mod = u % 86400000L;
        cdao.setStartDate(new Date(s));
        cdao.setEndDate(new Date(e));
        cdao.setUntil(new Date(u -= mod));
    }

    private static final Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSubfolders() {
        try {
            RdbFolderSQLInterface folderSQLInterface = new RdbFolderSQLInterface(ServerSessionAdapter.valueOf((Session)this.session));
            SearchIterator it = null;
            try {
                it = folderSQLInterface.getSubfolders(1, null);
                if (it.size() != -1) {
                    int size = it.size();
                    FolderTest.assertTrue((size >= 3 ? 1 : 0) != 0);
                    for (int i = 0; i < size; ++i) {
                        FolderObject fo = (FolderObject)it.next();
                        FolderTest.assertTrue((fo != null ? 1 : 0) != 0);
                    }
                } else {
                    FolderTest.assertTrue((boolean)it.hasNext());
                    while (it.hasNext()) {
                        FolderObject fo = (FolderObject)it.next();
                        FolderTest.assertTrue((fo != null ? 1 : 0) != 0);
                    }
                }
            }
            finally {
                if (it != null) {
                    it.close();
                    it = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSubfoldersWithRestrictedAccess() {
        try {
            UserConfiguration uc = FolderTest.getUserConfiguration(this.ctx, this.userId);
            uc.setCalendar(false);
            FolderTest.saveUserConfiguration(uc);
            try {
                RdbFolderSQLInterface folderSQLInterface = new RdbFolderSQLInterface(ServerSessionAdapter.valueOf((Session)this.session));
                SearchIterator it = folderSQLInterface.getSubfolders(1, null);
                try {
                    if (it.size() != -1) {
                        int size = it.size();
                        FolderTest.assertTrue((size >= 1 ? 1 : 0) != 0);
                        for (int i = 0; i < size; ++i) {
                            FolderObject fo = (FolderObject)it.next();
                            FolderTest.assertTrue((fo.getModule() != 2 ? 1 : 0) != 0);
                        }
                    } else {
                        FolderTest.assertTrue((boolean)it.hasNext());
                        while (it.hasNext()) {
                            FolderObject fo = (FolderObject)it.next();
                            FolderTest.assertTrue((fo.getModule() != 2 ? 1 : 0) != 0);
                        }
                    }
                }
                finally {
                    it.close();
                }
            }
            finally {
                UserConfiguration uc0 = FolderTest.getUserConfiguration(this.ctx, this.userId);
                uc0.setCalendar(true);
                FolderTest.saveUserConfiguration(uc0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }
}

