/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.reports;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.reports.SyncCollectionResponse;
import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SyncCollectionReportMethod
extends ReportMethod {
    private String syncToken = null;
    private Document responseDocument = null;

    public SyncCollectionReportMethod(String uri, ReportInfo reportInfo) throws IOException {
        super(uri, reportInfo);
    }

    public String getSyncTokenFromResponse() {
        return this.syncToken;
    }

    public SyncCollectionResponse getResponseBodyAsSyncCollection() throws IOException, DavException {
        this.checkUsed();
        return new SyncCollectionResponse(this.getResponseBodyAsMultiStatus(), this.syncToken);
    }

    public Document getResponseBodyAsDocument() throws IOException {
        if (null == this.responseDocument) {
            this.responseDocument = super.getResponseBodyAsDocument();
        }
        return this.responseDocument;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        super.processResponseBody(httpState, httpConnection);
        Document document = null;
        try {
            document = this.getResponseBodyAsDocument();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ElementIterator it = DomUtil.getChildren((Element)document.getDocumentElement(), (String)PropertyNames.SYNC_TOKEN.getName(), (Namespace)PropertyNames.SYNC_TOKEN.getNamespace());
        if (it.hasNext()) {
            Element respElem = it.nextElement();
            this.syncToken = respElem.getTextContent();
        }
    }
}

