/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Bug22451Test
extends CalDAVTest {
    public Bug22451Test(String name) {
        super(name);
    }

    public void testUntilDate() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("3 days after midnight", TimeZone.getTimeZone("UTC")));
        Date serverUntil = calendar.getTime();
        calendar.setTime(TimeTools.D("Tomorrow at midnight", TimeZone.getTimeZone("Europe/Berlin")));
        for (int i = 0; i < 24; ++i) {
            Appointment appointment = new Appointment();
            appointment.setUid(Bug22451Test.randomUID());
            appointment.setTitle("Series " + i);
            appointment.setIgnoreConflicts(true);
            appointment.setStartDate(calendar.getTime());
            calendar.add(11, 1);
            appointment.setEndDate(calendar.getTime());
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            appointment.setUntil(serverUntil);
            super.create(appointment);
            appointments.add(appointment);
        }
        Date clientLastModified = this.getManager().getLastModification();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar userCalendar = Calendar.getInstance(this.getClient().getValues().getTimeZone());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug22451Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22451Test.assertContains(appointment.getUid(), calendarData);
            Bug22451Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Bug22451Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)iCalResource.getVEvent().getSummary());
            Bug22451Test.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)iCalResource.getVEvent().getDTStart());
            Bug22451Test.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)iCalResource.getVEvent().getDTEnd());
            SimpleICal.Property rruleProperty = iCalResource.getVEvent().getProperty("RRULE");
            Bug22451Test.assertNotNull((String)"RRULE not found", (Object)rruleProperty);
            int startIndex = rruleProperty.getValue().indexOf("UNTIL=") + 6;
            int endIndex = rruleProperty.getValue().indexOf(";", startIndex);
            String iCalUntil = 0 < endIndex ? rruleProperty.getValue().substring(startIndex, endIndex) : rruleProperty.getValue().substring(startIndex);
            userCalendar.setTime(dateFormat.parse(iCalUntil));
            calendar.setTime(appointment.getUntil());
            Bug22451Test.assertEquals((String)"UNTIL date wrong", (int)calendar.get(5), (int)userCalendar.get(5));
        }
        for (ICalResource iCalResource : calendarData) {
            iCalResource.getVEvent().setSummary(iCalResource.getVEvent().getSummary() + "_edit");
            Bug22451Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        }
        List<Appointment> updates = super.getManager().updates(Bug22451Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Bug22451Test.assertNotNull((String)"no updates found on server", updates);
        Bug22451Test.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        for (Appointment appointment : appointments) {
            Appointment updatedAppointment = null;
            for (Appointment update : updates) {
                if (appointment.getObjectID() != update.getObjectID()) continue;
                updatedAppointment = update;
                break;
            }
            Bug22451Test.assertNotNull((String)"Exception not found", updatedAppointment);
            Bug22451Test.assertEquals((String)"Title wrong", (String)(appointment.getTitle() + "_edit"), (String)updatedAppointment.getTitle());
            Bug22451Test.assertEquals((String)"Until date wrong", (Object)appointment.getUntil(), (Object)updatedAppointment.getUntil());
        }
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug22451Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22451Test.assertContains(appointment.getUid(), calendarData);
            Bug22451Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Bug22451Test.assertEquals((String)"SUMMARY wrong", (String)(appointment.getTitle() + "_edit"), (String)iCalResource.getVEvent().getSummary());
            SimpleICal.Property rruleProperty = iCalResource.getVEvent().getProperty("RRULE");
            Bug22451Test.assertNotNull((String)"RRULE not found", (Object)rruleProperty);
            int startIndex = rruleProperty.getValue().indexOf("UNTIL=") + 6;
            int endIndex = rruleProperty.getValue().indexOf(";", startIndex);
            String iCalUntil = 0 < endIndex ? rruleProperty.getValue().substring(startIndex, endIndex) : rruleProperty.getValue().substring(startIndex);
            userCalendar.setTime(dateFormat.parse(iCalUntil));
            calendar.setTime(appointment.getUntil());
            Bug22451Test.assertEquals((String)"UNTIL date wrong", (int)calendar.get(5), (int)userCalendar.get(5));
        }
    }
}

