/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.contact.internal.Tools;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;

public class Bug22338Test
extends CalDAVTest {
    public Bug22338Test(String name) {
        super(name);
    }

    public void testLastModified() throws Exception {
        String uid = Bug22338Test.randomUID();
        String summary = "bug 22338";
        String location = "test";
        Date start = TimeTools.D("tomorrow at 2pm");
        Date end = TimeTools.D("tomorrow at 8pm");
        String iCal = Bug22338Test.generateICal(start, end, uid, summary, location);
        Bug22338Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        Bug22338Test.assertEquals(appointment, start, end, uid, summary, location);
        Date clientLastModified = super.getManager().getLastModification();
        ICalResource iCalResource = super.get(uid, null);
        Bug22338Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug22338Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug22338Test.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        Bug22338Test.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
        Bug22338Test.assertEquals((String)"DTSTART wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        Bug22338Test.assertEquals((String)"DTEND wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
        Date updatedStart = TimeTools.D("tomorrow at 4pm");
        Date updatedEnd = TimeTools.D("tomorrow at 10pm");
        iCalResource.getVEvent().setDTStart(updatedStart);
        iCalResource.getVEvent().setDTEnd(updatedEnd);
        Bug22338Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        List<Appointment> updates = super.getManager().updates(Tools.parse((String)this.getDefaultFolderID()), clientLastModified, false);
        Bug22338Test.assertNotNull((String)"appointment not found on server", updates);
        Bug22338Test.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        Appointment updatedAppointment = null;
        for (Appointment update : updates) {
            if (!uid.equals(update.getUid())) continue;
            updatedAppointment = update;
            break;
        }
        Bug22338Test.assertNotNull((String)"appointment not listed in updates", updatedAppointment);
        Bug22338Test.assertEquals(updatedAppointment, updatedStart, updatedEnd, uid, summary, location);
        Bug22338Test.assertTrue((String)"last modified not changed", (boolean)clientLastModified.before(super.getManager().getLastModification()));
    }
}

