/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.ajax.user.actions.SearchRequest;
import com.openexchange.ajax.user.actions.SearchResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug13911Test
extends AbstractAJAXSession {
    private static final Log LOG = LogFactory.getLog(Bug13911Test.class);
    private static final int[] COLUMNS = new int[]{1, 20, 500, 555, 602, 524, 556, 557, 502, 501};
    private AJAXClient client;
    private Contact contact;

    public Bug13911Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        GetResponse response = this.client.execute(new GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone()));
        this.contact = response.getContact();
    }

    public void testPatternSearchMultiple() throws Throwable {
        for (String value : new String[]{this.contact.getDisplayName(), this.contact.getSurName(), this.contact.getGivenName(), this.contact.getEmail1()}) {
            String pattern = Bug13911Test.surroundWithWildcards(this.getPart(value));
            LOG.info((Object)("Pattern: " + pattern));
            ContactSearchObject cso = new ContactSearchObject();
            cso.setDisplayName(pattern);
            cso.setEmail1(pattern);
            cso.setEmail2(pattern);
            cso.setEmail3(pattern);
            cso.setSurname(pattern);
            cso.setGivenName(pattern);
            cso.setOrSearch(true);
            SearchRequest[] searches = new SearchRequest[]{new SearchRequest(cso, COLUMNS, true)};
            SearchResponse response = (SearchResponse)((MultipleResponse)this.client.execute(new MultipleRequest(searches))).getResponse(0);
            boolean found = false;
            for (Object[] test : response) {
                int id = (Integer)test[response.getColumnPos(1)];
                if (id != this.contact.getObjectID()) continue;
                found = true;
                break;
            }
            Bug13911Test.assertTrue((String)"Searched user contact not found.", (boolean)found);
        }
    }

    public void testPatternSearch() throws Throwable {
        for (String value : new String[]{this.contact.getDisplayName(), this.contact.getSurName(), this.contact.getGivenName(), this.contact.getEmail1()}) {
            String pattern = Bug13911Test.surroundWithWildcards(this.getPart(value));
            LOG.info((Object)("Pattern: " + pattern));
            ContactSearchObject cso = new ContactSearchObject();
            cso.setDisplayName(pattern);
            cso.setEmail1(pattern);
            cso.setEmail2(pattern);
            cso.setEmail3(pattern);
            cso.setSurname(pattern);
            cso.setGivenName(pattern);
            cso.setOrSearch(true);
            SearchRequest request = new SearchRequest(cso, COLUMNS, true);
            SearchResponse response = this.client.execute(request);
            boolean found = false;
            for (Object[] test : response) {
                int id = (Integer)test[response.getColumnPos(1)];
                if (id != this.contact.getObjectID()) continue;
                found = true;
                break;
            }
            Bug13911Test.assertTrue((String)"Searched user contact not found.", (boolean)found);
        }
    }

    private String getPart(String value) {
        Random rand = new Random(System.currentTimeMillis());
        int start = rand.nextInt(value.length());
        int length = rand.nextInt(value.length() - start);
        return value.substring(start, start + length);
    }

    private static String surroundWithWildcards(String value) {
        String ret = value;
        if ("".equals(ret) || ret.charAt(0) != '*') {
            ret = new StringBuilder(ret.length() + 1).append('*').append(ret).toString();
        }
        if (ret.charAt(ret.length() - 1) != '*' || ret.length() > 1 && ret.charAt(ret.length() - 2) == '\\') {
            ret = new StringBuilder(ret.length() + 1).append(ret).append('*').toString();
        }
        return ret;
    }
}

