/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTestForAJAXClient;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.TestTask;
import com.openexchange.test.TaskTestManager;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Bug12727Test
extends AbstractTaskTestForAJAXClient {
    private AJAXClient client;
    private TaskTestManager manager;
    private TestTask task;

    public Bug12727Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.manager = new TaskTestManager(this.client);
        this.createTask();
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testOccurrences() throws OXException, IOException, SAXException, JSONException {
        ListRequest request = new ListRequest(ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}}), new int[]{20, 1, 222}, false);
        CommonListResponse response = this.client.execute(request);
        if (response.hasError()) {
            Bug12727Test.fail((String)response.getException().toString());
        }
        int columnPos = response.getColumnPos(222);
        for (Object[] data : response) {
            Bug12727Test.assertEquals((String)"Column with recurrence count is missing.", (int)(columnPos + 1), (int)data.length);
            Bug12727Test.assertEquals((String)"Occurrences does not match.", (Object)5, (Object)data[columnPos]);
        }
    }

    private void createTask() throws OXException, IOException, SAXException, JSONException {
        this.task = this.getNewTask("Test for bug 12727");
        this.task.startsToday();
        this.task.endsTheFollowingDay();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.everyDay();
        this.task.occurs(5);
        this.manager.insertTaskOnServer(this.task);
    }
}

